<?php
namespace SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel;

use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Shopware\Core\System\SalesChannel\SalesChannelEntity;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity;

class SicoProductgroupSalesChannelEntity extends Entity{
    use EntityIdTrait;

    /** @var string */
    protected $productgroupId;

    /** @var string */
    protected $salesChannelId;

    /** @var SicoProductgroupEntity */
    protected $productgroup;

    /** @var SalesChannelEntity */
    protected $salesChannel;

    /**
     * @return string
     */
    public function getProductgroupId(): string
    {
        return $this->productgroupId;
    }

    /**
     * @param string $productgroup_id
     */
    public function setProductgroupId(string $productgroupId): void
    {
        $this->productgroupId = $productgroupId;
    }

    /**
     * @return string
     */
    public function getSalesChannelId(): string
    {
        return $this->salesChannelId;
    }

    /**
     * @param string $salesChannel_id
     */
    public function setSalesChannelId(string $salesChannelId): void
    {
        $this->salesChannelId = $salesChannelId;
    }

    /**
     * @return SicoProductgroupEntity
     */
    public function getProductgroup(): SicoProductgroupEntity
    {
        return $this->productgroup;
    }

    /**
     * @param SicoProductgroupEntity $productgroup
     */
    public function setProductgroup(SicoProductgroupEntity $productgroup): void
    {
        $this->productgroup = $productgroup;
    }

    /**
     * @return SalesChannelEntity
     */
    public function getSalesChannel(): SalesChannelEntity
    {
        return $this->salesChannel;
    }

    /**
     * @param SalesChannelEntity $salesChannel
     */
    public function setSalesChannel(SalesChannelEntity $salesChannel): void
    {
        $this->salesChannel = $salesChannel;
    }


}
