<?php
/**
 * Created by PhpStorm.
 * User: philipp.holzmann
 * Date: 25.05.2021
 * Time: 08:45
 */
namespace SicoCreditPlus\Core\Rule;

use Shopware\Core\Checkout\Cart\Rule\CartRuleScope;
use Shopware\Core\Checkout\CheckoutRuleScope;
use Shopware\Core\Framework\Rule\Rule;
use Shopware\Core\Framework\Rule\RuleScope;
use SicoCreditPlus\Service\CreditPlusPayment;
use Symfony\Component\Validator\Constraints\Type;

class CreditPlusStatusRule extends Rule{

	/**
	 * @var int
	 */
	protected $creditPlusStatus;

	public function __construct()
	{
		parent::__construct();
		$this->creditPlusStatus = 0;
	}

	public function getName(): string
	{
		return 'credit_plus_status_rule';
	}

	public function match(RuleScope $scope): bool
	{
		if (!$scope instanceof CheckoutRuleScope) {
			return false;
		}
		if(!$scope instanceof CartRuleScope){
			return false;
		}


		$paymenName = $scope->getSalesChannelContext()->getPaymentMethod()->getHandlerIdentifier();
		if($paymenName !== CreditPlusPayment::class){
			return false;
		}
		if(!$scope->getCart()->getData()->has('CreditPlusContractStatus')){
			return false;
		}
		$iCreditPlusContractStatus = (int)$scope->getCart()->getData()->get('CreditPlusContractStatus');
		if($iCreditPlusContractStatus === $this->creditPlusStatus){
			return true;
		}

		return false;

	}


	public function getConstraints(): array
	{
		return [
			'creditPlusStatus' => [new Type('int')]
		];
	}

}
