<?php

namespace SicoCreditPlus\Lib\CreditPlusObjects;

/**
 * Created by PhpStorm.
 * User: mihovil.bubnjar
 * Date: 22.01.16
 * Time: 10:45
 *
 * Transfer Class for getContracts Response items
 */
class WebshopContract {
	/** @var bool $addressChanged */
	public bool $addressChanged = false;

	/** @var string $areaCode */
	public string $areaCode = '';

	/** @var string|null $cancelationDate */
	public ?string $cancelationDate = '';

	/** @var string|null $cancelationFrom */
	public ?string $cancelationFrom = '';

	/** @var string $conditionName */
	public string $conditionName = '';

	/** @var int $cpReferenceNumber */
	public int $cpReferenceNumber = 0;

	/** @var int $creditDuration */
	public int $creditDuration = 0;

	/** @var int $dealerNumber */
	public int $dealerNumber = 0;

	/** @var string $dealerOrderNumber */
	public string $dealerOrderNumber = '';

	/** @var string $decisionDate */
	public string $decisionDate = '';

	/** @var bool deliveryDone */
	public bool $deliveryDone = false;

	/** @var bool $finallyApproved */
	public string|bool $finallyApproved = '';

	/** @var string $firstDecisionDate */
	public string $firstDecisionDate = '';

	/** @var string $forename */
	public string $forename = '';

	/** @var int $id */
	public int $id = 0;

	/** @var bool $informationRequest */
	public bool $informationRequest = false;

	/** @var int $krebesReference */
	public int $krebesReference = 0;

	/** @var bool $loginWebshop */
	public bool $loginWebshop = false;

	/** @var string $name */
	public string $name = '';

	/** @var string $orderDate */
	public string $orderDate = '';

	/** @var string|float $price */
	public string|float $price = '';

	/** @var string|int $state */
	public string|int $state = '';

	/** @var string $stateText */
	public string $stateText = '';

	/** @var string $street */
	public string $street = '';

	/** @var string $town */
	public $town = '';

	/** @var WebshopVoucher[] $voucher */
	public $voucher = array();

	/** @var string $completeOrderUrl */
	public $completeOrderUrl = '';

	private static function checkProperty(\ReflectionObject $oReflectionObj,WebshopContract $oContract,$oObject,string $property): void
	{
		if($oReflectionObj->hasProperty($property)){
			$oContract->$property = $oObject->$property;
		}
		else{
			$oContract->$property = null;
		}
	}

	/**
	 * Creates a WebshopContract out of transferred Data
	 *
	 * @param WebshopContract $oObject
	 * @return WebshopContract
	 */
	public static function fromObject($oObject): WebshopContract
	{
		$oContract = new WebshopContract();

		$oReflectionObj = new \ReflectionObject($oObject);
		self::checkProperty($oReflectionObj,$oContract,$oObject,'addressChanged');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'areaCode');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'cancelationDate');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'cancelationFrom');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'conditionName');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'cpReferenceNumber');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'creditDuration');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'dealerNumber');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'dealerOrderNumber');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'decisionDate');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'deliveryDone');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'finallyApproved');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'firstDecisionDate');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'forename');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'id');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'informationRequest');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'krebesReference');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'loginWebshop');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'name');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'orderDate');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'price');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'state');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'stateText');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'street');
		self::checkProperty($oReflectionObj,$oContract,$oObject,'town');

		$aVoucher = array();
		if($oReflectionObj->hasProperty('voucher')){
			foreach ( $oObject->voucher as $oObjectVoucher ) {
				$oVoucher = WebshopVoucher::fromObject($oObjectVoucher);
				$aVoucher[] = $oVoucher;
			}
			$oContract->voucher = $aVoucher;
			$oContract->completeOrderUrl = $oObject->completeOrderUrl;
		}
		else{
			$oContract->voucher = null;
		}

		return $oContract;
	}

}
