<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1618383723InorderMigration extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1618383723;
    }

    public function update(Connection $connection): void
    {
    	$sql = 'SHOW COLUMNS FROM sico_credit_plus_payment';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasOrderFinishColumn = false;
		foreach($fields as $field){
			if($field['Field'] === 'order_finish'){
				$bHasOrderFinishColumn = true;
			}
		}
		if(!$bHasOrderFinishColumn){
			// implement update
			$sql = 'ALTER TABLE sico_credit_plus_payment ADD COLUMN order_finish varchar(255)';
			$connection->executeStatement($sql);
		}
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
