<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1626698385addStatusChangeUrlColumn extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1626698385;
    }

    public function update(Connection $connection): void
    {
		$sql = 'SHOW COLUMNS FROM sico_credit_plus_payment';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasBackUrl = false;
		foreach($fields as $field){
			if($field['Field'] === 'status_change_url'){
				$bHasBackUrl = true;
			}
		}
		if(!$bHasBackUrl){
			$sql = 'ALTER TABLE sico_credit_plus_payment ADD COLUMN status_change_url varchar(400) null';
			$connection->executeStatement($sql);
		}
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
