<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1694597112CartSave extends MigrationStep
{
	public function getCreationTimestamp(): int
	{
		return 1694597112;
	}

	public function update(Connection $connection): void
	{
		$connection->executeStatement('
create table IF NOT EXISTS sico_credit_plus_saved_cart
(
	`id`                   BINARY(16) PRIMARY KEY,
	`name`                 varchar(255) not null,
	`token`                varchar(255) not null,
	`price`                JSON null,
	`line_item_count`      INT(11) DEFAULT 0 null,
	`currency_id`          BINARY(16) null,
	`shipping_method_id`   BINARY(16) null,
	`payment_method_id`    BINARY(16) null,
	`country_id`           BINARY(16) null,
	`customer_id`          BINARY(16) null,
	`sales_channel_id`     BINARY(16) null,
	`auto_increment`       BIGINT not null auto_increment,
	`compressed`           TINYINT(1) DEFAULT 0 not null,
	`payload`              LONGBLOB null,
	`rule_ids`             JSON null,
	`dealer_order_number`  varchar(255) null,
	`created_at`           DATETIME(3) NOT NULL,
	`updated_at`           DATETIME(3) NULL,
	CONSTRAINT AUTO_INCREMENT UNIQUE (auto_increment),
	CONSTRAINT `fk.sico_saved_cart.country_id` FOREIGN KEY (country_id) REFERENCES country (id) ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT `fk.sico_saved_cart.currency_id` FOREIGN KEY (currency_id) REFERENCES currency (id) ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT `fk.sico_saved_cart.customer_id` FOREIGN KEY (customer_id) REFERENCES customer (id) ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT `fk.sico_saved_cart.payment_method_id` FOREIGN KEY (payment_method_id) REFERENCES payment_method (id) ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT `fk.sico_saved_cart.shipping_method_id` FOREIGN KEY (shipping_method_id) REFERENCES shipping_method (id) ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT `fk.sico_saved_cart.sales_channel_id` FOREIGN KEY (sales_channel_id) REFERENCES sales_channel (id) ON UPDATE CASCADE ON DELETE CASCADE,
	INDEX `idx.sico_saved_cart.created_at` (created_at) 
) COLLATE = utf8mb4_unicode_ci');
	}

	public function updateDestructive(Connection $connection): void
	{
		// implement update destructive
	}
}
