<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Result;
use Shopware\Core\Defaults;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1716550497ActivationFailedMail extends MigrationStep
{
	public function getCreationTimestamp(): int
	{
		return 1716550497;
	}

	/**
	 * @param Connection $connection Database connection, default Doctrine stuff
	 * @return void
	 * @throws Exception Regular Doctrine stuff
	 */
	public function update(Connection $connection): void
	{
		$this->addActivationFailedMail($connection);
	}

	/**
	 * @param Connection $oConnection Database connection, default Doctrine stuff
	 * @return void
	 * @throws Exception Regular Doctrine stuff
	 */
	private function addActivationFailedMail(Connection $oConnection): void
	{
		$sEmailTemplateHtml =  file_get_contents(dirname(__DIR__).'/DefaultMails/sCreditPlusOrderActivationFailed_html.html.twig');
		$sEmailTemplatePlain =  file_get_contents(dirname(__DIR__).'/DefaultMails/sCreditPlusOrderActivationFailed_plain.html.twig');

		$statusMail = 'sCreditPlusOrderActivationFailed';
		$deLangId = $this->getLanguageIdByLocale($oConnection, 'de-DE');
		$enLangId = $this->getLanguageIdByLocale($oConnection, 'en-GB');

		$aMailTemplateType = [
			'id' => hex2bin(md5($statusMail.'_type')),
			'technical_name' => $statusMail,
			'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT),
			'available_entities' => '{}'
		];
		$aMailTemplateTypeTranslation = [
			'mail_template_type_id' => hex2bin(md5($statusMail.'_type')),
			'language_id' => $deLangId,
			'name' => $statusMail,
			'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
		];
		if(!$this->hasMailTemplateType($oConnection, md5($statusMail.'_type'))){
			$oConnection->insert('mail_template_type', $aMailTemplateType);
			if($deLangId !== false){
				$oConnection->insert('mail_template_type_translation', $aMailTemplateTypeTranslation);
			}
			if($enLangId !== false) {
				$aMailTemplateTypeTranslation['language_id'] = $enLangId;
				$oConnection->insert('mail_template_type_translation', $aMailTemplateTypeTranslation);
			}
		}

		$aMailTemplate = [
			'id' => hex2bin(md5($statusMail)),
			'mail_template_type_id' => hex2bin(md5($statusMail.'_type')),
			'system_default' => 0,
			'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
		];
		$aMailTemplateTranslation = [
			'mail_template_id' => hex2bin(md5($statusMail)),
			'language_id' => $deLangId,
			'sender_name' => '{{ salesChannel.name }}',
			'subject' => 'Fehler bei Versendet-Meldung in {{ salesChannel.name }}',
			'description' => 'Markierung der CreditPlus Bestellung as Versendet',
			'content_html' => $sEmailTemplateHtml,
			'content_plain' => $sEmailTemplatePlain,
			'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
		];
		if(!$this->hasMailTemplate($oConnection, md5($statusMail))){
			$oConnection->insert('mail_template',$aMailTemplate);
			if($deLangId !== false){
				$oConnection->insert('mail_template_translation', $aMailTemplateTranslation);
			}
			if($enLangId !== false){
				$aMailTemplateTranslation['language_id'] = $enLangId;
				$oConnection->insert('mail_template_translation', $aMailTemplateTranslation);
			}

		}
	}

	public function updateDestructive(Connection $connection): void
	{
		// implement update destructive
	}

	/**
	 * @param Connection $connection
	 * @param string $locale
	 */
	private function getLanguageIdByLocale(Connection $connection, string $locale){
		$sql = 'SELECT language.id FROM language LEFT JOIN locale ON language.locale_id = locale.id WHERE locale.code LIKE ?';
		$param = [$locale];
		if(method_exists($connection,'fetchAssociative')){
			$aLanguageId = $connection->fetchAssociative($sql,$param);
		} else if(method_exists($connection,'fetchAssoc')){
			$aLanguageId = $connection->fetchAssoc($sql,$param);
		} else {
			$aLanguageId = false;
		}

		return ($aLanguageId === false)?false:$aLanguageId['id'];
	}
	private function hasMailTemplateType(Connection $connection,$mailTemplateTypeId){
		$sql = 'SELECT COUNT(*) FROM mail_template_type WHERE id = UNHEX(?)';
		$param = [$mailTemplateTypeId];
		if(method_exists($connection,'fetchAssociative')){
			$count =$connection->fetchAssociative($sql,$param);
		} else if(method_exists($connection,'fetchAssoc')){
			$count = $connection->fetchAssoc($sql,$param);
		} else {
			$count = false;
		}

		return $count['COUNT(*)'] >= 1;
	}
	private function hasMailTemplate(Connection $connection,$mailTemplateId){
		$sql = 'SELECT COUNT(*) FROM mail_template WHERE id = UNHEX(?)';
		$param = [$mailTemplateId];
		if(method_exists($connection,'fetchAssociative')) {
			$count = $connection->fetchAssociative($sql, $param);
		} else if(method_exists($connection,'fetchAssoc')){
			$count = $connection->fetchAssoc($sql, $param);
		} else {
			$count = false;
		}
		return $count['COUNT(*)'] >= 1;
	}
}
