<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception as DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1719228161CalculatedRates extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1719228161;
    }

	/**
	 * Creates the new table for calculated financing months.
	 * Adds field to product table.
	 *
	 * @param Connection $connection
	 * @return void
	 * @throws \Doctrine\DBAL\Exception
	 */
    public function update(Connection $connection): void
    {
        $connection->executeStatement("
        CREATE TABLE IF NOT EXISTS sico_credit_plus_calculated_rate (
            `id` BINARY(16) NOT NULL,
            `product_id` BINARY (16),
            `product_version_id` BINARY (16),
            `sico_sales_channel_id` BINARY (16),
  			`sico_min_months` int(11),
  			`sico_min_months_interest_rate` double,
  			`sico_min_months_rate` double,
  			`sico_max_months` int(11),
  			`sico_max_months_interest_rate` double,
  			`sico_max_months_rate` double,
  			`sico_absolute_min_rate_months` int(11),
  			`sico_absolute_min_rate_interest_rate` double,
  			`sico_absolute_min_rate_rate` double,
  			`sico_fictional_min_rate_months` int(11),
  			`sico_fictional_min_rate_interest_rate` double,
  			`sico_fictional_min_rate_rate` double,
  			`sico_currency_id` BINARY(16),
  			`sico_calculation_finished` tinyint(1) NULL DEFAULT NULL,
  			`created_at` DATETIME(3) NOT NULL,
  			`updated_at` DATETIME(3) NULL,
  			PRIMARY KEY(`id`),
  			FOREIGN KEY (`sico_currency_id`) references currency (id),
  			FOREIGN KEY (`sico_sales_channel_id`) references sales_channel (id),
  			FOREIGN KEY (`product_id`) references product (id)
        );
        ");
        $sql = 'SHOW COLUMNS FROM `product`';
        $resultStatement = $connection->executeQuery($sql);
        $fields = $resultStatement->fetchAllAssociative();
        $bHasColumn = false;
        foreach ($fields as $field) {
            if ($field['Field'] === 'sicoCreditPlusCalculatedRates') {
                $bHasColumn = true;
            }
        }
		// Add new field to product table
        try {
            if (!$bHasColumn) {
                $connection->executeStatement("
			    	ALTER TABLE product ADD sicoCreditPlusCalculatedRates BINARY (16) NULL DEFAULT id
				");
			}
		} catch ( \Exception $oException ) {
			try {
				if (!$bHasColumn) {
					// MySQL 5.7 does not allow to add a default value of another column, create a trigger instead
					$connection->executeStatement("
			    		ALTER TABLE product ADD sicoCreditPlusCalculatedRates BINARY (16) NULL DEFAULT NULL;
					");
					$connection->executeStatement("
						CREATE TRIGGER product_before_insert_creditplus_rates BEFORE INSERT ON product FOR EACH ROW
						BEGIN
							IF NEW.sicoCreditPlusCalculatedRates IS NULL THEN
								SET NEW.sicoCreditPlusCalculatedRates = NEW.id;
							END IF;
						END;
					");
				}
			} catch ( \Exception $oInnerException ) {
				// Maybe the trigger failed to be created, this is as far as we can go.
				if ( $oInnerException instanceof DBALException ) {
					throw $oInnerException;
				}
			}
			// Ignore if field already exists
		}
		// Fill the new field with data
		$connection->executeStatement("
			UPDATE product SET sicoCreditPlusCalculatedRates = id WHERE sicoCreditPlusCalculatedRates IS NULL;
		");
	}

    public function updateDestructive(Connection $connection): void
    {
        // No destructive updates exists
    }
}
