<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 03.02.2020
 * Time: 16:02
 */

namespace SicoCreditPlus\Subscriber;

use Shopware\Core\System\SystemConfig\SystemConfigService;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Shopware\Core\Framework\Struct\ArrayEntity;
use Shopware\Storefront\Framework\Routing\Router;
use Shopware\Storefront\Page\Account\Order\AccountOrderPageLoadedEvent;
use Shopware\Storefront\Page\Account\Overview\AccountOverviewPageLoadedEvent;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class AccountOrderSubscriber implements EventSubscriberInterface{

	/** @var Router */
	protected $oRouter;

	/** @var SystemConfigService  */
	private $oSystemConfigService;

	public function __construct(UrlGeneratorInterface $router,SystemConfigService $oSystemConfigService)
	{
		$this->oRouter = $router;
		$this->oSystemConfigService = $oSystemConfigService;
	}

	/**
	 * Returns an array of event names this subscriber wants to listen to.
	 *
	 * The array keys are event names and the value can be:
	 *
	 *  * The method name to call (priority defaults to 0)
	 *  * An array composed of the method name to call and the priority
	 *  * An array of arrays composed of the method names to call and respective
	 *    priorities, or 0 if unset
	 *
	 * For instance:
	 *
	 *  * array('eventName' => 'methodName')
	 *  * array('eventName' => array('methodName', $priority))
	 *  * array('eventName' => array(array('methodName1', $priority), array('methodName2')))
	 *
	 * @return array The event names to listen to
	 */
	public static function getSubscribedEvents()
	{
		return [
			AccountOrderPageLoadedEvent::class => 'onOrderLoaded',
			AccountOverviewPageLoadedEvent::class => 'onOverviewLoaded'
		];
	}

	public function onOverviewLoaded(AccountOverviewPageLoadedEvent $event)
	{
		$this->generateBackUrl($event);
	}

	public function onOrderLoaded(AccountOrderPageLoadedEvent $event)
	{
		$this->generateBackUrl($event);
	}

	public function generateBackUrl(PageLoadedEvent $event){
		$sSelectedView = $this->oSystemConfigService->get('SicoCreditPlus.config.sCPShownAs');
		switch($sSelectedView){
			case 'popup':
				$sRouteName = 'frontend.creditplus.trigger.popup';
				break;
			case 'iframe':
				$sRouteName = 'frontend.creditplus.trigger.iframe';
				break;
			case 'new_window':
				$sRouteName = 'frontend.creditplus.trigger.new-window';
				break;
			default:
				$sRouteName = 'frontend.creditplus.trigger.popup';
		}
		$url = $this->oRouter->generate('frontend.creditplus.trigger',['statusText' => 30307]);
		$urlBase64 = base64_encode($url);
		$entity = new ArrayEntity([
			'backUrl' => $urlBase64,
			'selectedView' => $sRouteName
		]);
		$event->getPage()->addExtension('SicoCreditPlus',$entity);
	}
}
