<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 04.01.2024
 * @time 13:20
 */

namespace SicoCreditPlus\Core\Content\ProductStream;

use Shopware\Core\Content\ProductStream\ProductStreamDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;

if ( interface_exists('Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface') ) {
	class ProductStreamExtensionBase implements \Shopware\Core\Framework\DataAbstractionLayer\EntityExtensionInterface {
		public function extendFields(FieldCollection $collection ): void {

		}

		public function getDefinitionClass(): string {
			return ProductStreamDefinition::class;
		}
	}
} else {
	class ProductStreamExtensionBase extends \Shopware\Core\Framework\DataAbstractionLayer\EntityExtension {
		public function extendFields(FieldCollection $collection ): void {

		}

		public function getDefinitionClass(): string {
			return ProductStreamDefinition::class;
		}
	}
}

class ProductStreamExtension extends ProductStreamExtensionBase
{
	public function extendFields(FieldCollection $collection): void
	{
		$collection->add(
			(new OneToManyAssociationField(
				'sicoProductGroup',
				SicoProductgroupDefinition::class,
				'id'))->addFlags(new CascadeDelete())
		);
	}
}
