<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 16.08.2023
 * @time 14:10
 */

namespace SicoCreditPlus\Core\Content\SicoCreditPlusSavedCart;

use Shopware\Core\Checkout\Customer\CustomerDefinition;
use Shopware\Core\Checkout\Payment\PaymentMethodDefinition;
use Shopware\Core\Checkout\Shipping\ShippingMethodDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\Country\CountryDefinition;
use Shopware\Core\System\Currency\CurrencyDefinition;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;

class SicoCreditPlusSavedCartDefinition extends EntityDefinition
{
	public const ENTITY_NAME = 'sico_credit_plus_saved_cart';

	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function since(): ?string
	{
		return '6.4.12.0';
	}

	public function getEntityClass(): string
	{
		return SicoCreditPlusSavedCartEntity::class;
	}

	public function getCollectionClass(): string
	{
		return SicoCreditPlusSavedCartCollection::class;
	}

	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new Field\IdField('id', 'id'))->addFlags(new Flag\PrimaryKey(), new Flag\Required()),
			(new Field\StringField('token', 'token')),
			(new Field\StringField('name', 'name')),
			(new Field\CartPriceField('price', 'price')),
			(new Field\IntField('line_item_count', 'lineItemCount')),
			(new Field\FkField('currency_id', 'currencyId', CurrencyDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('currency', 'currency_id', CurrencyDefinition::class, 'id')),
			(new Field\FkField('shipping_method_id', 'shippingMethodId', ShippingMethodDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('shippingMethod', 'shipping_method_id', ShippingMethodDefinition::class, 'id')),
			(new Field\FkField('payment_method_id', 'paymentMethodId', PaymentMethodDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('paymentMethod', 'payment_method_id', PaymentMethodDefinition::class, 'id')),
			(new Field\FkField('country_id', 'countryId', CountryDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('country', 'country_id', CountryDefinition::class, 'id')),
			(new Field\FkField('customer_id', 'customerId', CustomerDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('customer', 'customer_id', CustomerDefinition::class, 'id')),
			(new Field\FkField('sales_channel_id', 'salesChannelId', SalesChannelDefinition::class, 'id')),
			(new Field\ManyToOneAssociationField('salesChannel', 'sales_channel_id', SalesChannelDefinition::class, 'id')),
			(new Field\JsonField('rule_ids', 'ruleIds')),
			(new Field\StringField('dealer_order_number', 'dealerOrderNumber')),
			(new Field\CreatedAtField()),
			(new Field\UpdatedAtField()),
			(new Field\AutoIncrementField()),
			(new Field\BoolField('compressed', 'compressed')),
			(new Field\BlobField('payload', 'payload')),
		]);
	}
}
