<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 08.01.2020
 * Time: 14:04
 */

namespace SicoCreditPlus\Core\Content\SicoOfferedOption;

use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

class SicoOfferedOptionEntity extends Entity{
	use EntityIdTrait;

	/**
	 * @var int
	 */
	protected $sicoMonths;

	/**
	 * @var float
	 */
	protected $sicoInterest;

	/**
	 * @var string
	 */
	protected $sicoProdcode;

	/**
	 * @var bool
	 */
	protected $sicoActive;

	/**
	 * @var float
	 */
	protected $sicoRatefactor;

	/**
	 * @var \SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity
	 */
	protected $sicoProdgroup;

	/**
	 * @var string
	 */
	protected $sicoProdgroupId;

	/**
	 * @return int
	 */
	public function getSicoMonths(): int
	{
		return $this->sicoMonths;
	}

	/**
	 * @param int $sicoMonths
	 */
	public function setSicoMonths(int $sicoMonths): void
	{
		$this->sicoMonths = $sicoMonths;
	}

	/**
	 * @return float
	 */
	public function getSicoInterest(): float
	{
		return $this->sicoInterest;
	}

	/**
	 * @param float $sicoInterest
	 */
	public function setSicoInterest(float $sicoInterest): void
	{
		$this->sicoInterest = $sicoInterest;
	}

	/**
	 * @return string
	 */
	public function getSicoProdcode(): string
	{
		return $this->sicoProdcode;
	}

	/**
	 * @param string $sicoProdcode
	 */
	public function setSicoProdcode(string $sicoProdcode): void
	{
		$this->sicoProdcode = $sicoProdcode;
	}

	/**
	 * @return bool
	 */
	public function isSicoActive(): bool
	{
		return $this->sicoActive;
	}

	/**
	 * @param bool $sicoActive
	 */
	public function setSicoActive(bool $sicoActive): void
	{
		$this->sicoActive = $sicoActive;
	}

	/**
	 * @return float
	 */
	public function getSicoRatefactor(): float
	{
		return $this->sicoRatefactor;
	}

	/**
	 * @param float $sicoRatefactor
	 */
	public function setSicoRatefactor(float $sicoRatefactor): void
	{
		$this->sicoRatefactor = $sicoRatefactor;
	}

	/**
	 * @return \SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity
	 */
	public function getSicoProdgroup(): \SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity
	{
		return $this->sicoProdgroup;
	}

	/**
	 * @param \SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity $sicoProdgroup
	 */
	public function setSicoProdgroup(\SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupEntity $sicoProdgroup): void
	{
		$this->sicoProdgroup = $sicoProdgroup;
	}

	/**
	 * @return string
	 */
	public function getSicoProdgroupId(): string
	{
		return $this->sicoProdgroupId;
	}

	/**
	 * @param string $sicoProdgroupId
	 */
	public function setSicoProdgroupId(string $sicoProdgroupId): void
	{
		$this->sicoProdgroupId = $sicoProdgroupId;
	}



}
