<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 08.01.2020
 * Time: 15:47
 */
namespace SicoCreditPlus\Core\Content\SicoProductgroupProducts;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\CreatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;

class SicoProductgroupProductsDefinition extends EntityDefinition{

	public const ENTITY_NAME = 'sico_productgroup_s_articles';

	public function getEntityName(): string
	{
		return self::ENTITY_NAME;
	}

	public function getCollectionClass(): string
	{
		return SicoProductgroupProductsCollection::class;
	}

	public function getEntityClass(): string
	{
		return SicoProductgroupProductsEntity::class;
	}


	protected function defineFields(): FieldCollection
	{
		return new FieldCollection([
			(new FkField('productgroup_id','productgroupId', SicoProductgroupDefinition::class))->addFlags(new PrimaryKey(),new Required()),
			(new FkField('product_id','productId',ProductDefinition::class))->addFlags(new PrimaryKey(),new Required()),
			(new ManyToOneAssociationField('productgroup','productgroup_id',SicoProductgroupDefinition::class)),
			(new ManyToOneAssociationField('product','product_id',ProductDefinition::class)),
			(new ReferenceVersionField(ProductDefinition::class))->addFlags(new PrimaryKey(),new Required()),
			new CreatedAtField()
		]);
	}
}
