<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Defaults;

class Migration1621322067createInorderMailTemplates extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1621322067;
    }

    public function update(Connection $connection): void
    {
		$sEmailTemplateHtml =  file_get_contents(dirname(__DIR__).'/DefaultMails/sCreditPlusState_beforeOrder_html.html.twig');
		$sEmailTemplatePlain =  file_get_contents(dirname(__DIR__).'/DefaultMails/sCreditPlusState_beforeOrder_plain.html.twig');
		$statusMails = [
			'sCreditPlusStateBeforeOrder20',
			'sCreditPlusStateBeforeOrder24n',
			'sCreditPlusStateBeforeOrder24a',
			'sCreditPlusStateBeforeOrder25',
			'sCreditPlusStateBeforeOrder92',
			'sCreditPlusStateBeforeOrder95',
			'sCreditPlusStateBeforeOrder99',
		];
		$deLangId = $this->getLanguageIdByLocale($connection, 'de-DE');
		$enLangId = $this->getLanguageIdByLocale($connection, 'en-GB');

		$aMails=[];
		foreach($statusMails as $statusMail){
			$aMailTemplateType = [
				'id' => hex2bin(md5($statusMail.'_type')),
				'technical_name' => $statusMail,
				'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT),
				'available_entities' => '{}'
			];
			$aMailTemplateTypeTranslation = [
				'mail_template_type_id' => hex2bin(md5($statusMail.'_type')),
				'language_id' => $deLangId,
				'name' => $statusMail,
				'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
			];
			if(!$this->hasMailTemplateType($connection,md5($statusMail.'_type'))){
				$connection->insert('mail_template_type',$aMailTemplateType);
				if($deLangId !== false){
					$connection->insert('mail_template_type_translation',$aMailTemplateTypeTranslation);
				}
				if($enLangId !== false) {
					$aMailTemplateTypeTranslation['language_id'] = $enLangId;
					$connection->insert('mail_template_type_translation', $aMailTemplateTypeTranslation);
				}
			}

			$aMailTemplate = [
				'id' => hex2bin(md5($statusMail)),
				'mail_template_type_id' => hex2bin(md5($statusMail.'_type')),
				'system_default' => 0,
				'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
			];
			$aMailTemplateTranslation = [
				'mail_template_id' => hex2bin(md5($statusMail)),
				'language_id' => $deLangId,
				'sender_name' => '{{ salesChannel.name }}',
				'subject' => 'Status der Bestellung im {{ salesChannel.name }}',
				'description' => 'Statusänderung der CreditPlus Bestellung',
				'content_html' => $sEmailTemplateHtml,
				'content_plain' => $sEmailTemplatePlain,
				'created_at' => (new \DateTime())->format(Defaults::STORAGE_DATE_TIME_FORMAT)
			];
			if(!$this->hasMailTemplate($connection,md5($statusMail))){
				$connection->insert('mail_template',$aMailTemplate);
				if($deLangId !== false){
					$connection->insert('mail_template_translation',$aMailTemplateTranslation);
				}
				if($enLangId !== false){
					$aMailTemplateTranslation['language_id'] = $enLangId;
					$connection->insert('mail_template_translation',$aMailTemplateTranslation);
				}

			}
		}
    }

    public function updateDestructive(Connection $connection): void
    {

    }

	/**
	 * @param Connection $connection
	 * @param string $locale
	 */
    private function getLanguageIdByLocale(Connection $connection, string $locale){
        $sql = 'SELECT language.id FROM language LEFT JOIN locale ON language.locale_id = locale.id WHERE locale.code LIKE ?';
        $param = [$locale];
        if(method_exists($connection,'fetchAssociative')){
            $aLanguageId = $connection->fetchAssociative($sql,$param);
        } else if(method_exists($connection,'fetchAssoc')){
            $aLanguageId = $connection->fetchAssoc($sql,$param);
        } else {
            $aLanguageId = false;
        }

		return ($aLanguageId === false)?false:$aLanguageId['id'];
	}
	private function hasMailTemplateType(Connection $connection,$mailTemplateTypeId){
        $sql = 'SELECT COUNT(*) FROM mail_template_type WHERE id = UNHEX(?)';
        $param = [$mailTemplateTypeId];
        if(method_exists($connection,'fetchAssociative')){
            $count =$connection->fetchAssociative($sql,$param);
        } else if(method_exists($connection,'fetchAssoc')){
            $count = $connection->fetchAssoc($sql,$param);
        } else {
            $count = false;
        }

		return $count['COUNT(*)'] >= 1;
	}
	private function hasMailTemplate(Connection $connection,$mailTemplateId){
        $sql = 'SELECT COUNT(*) FROM mail_template WHERE id = UNHEX(?)';
        $param = [$mailTemplateId];
        if(method_exists($connection,'fetchAssociative')) {
            $count = $connection->fetchAssociative($sql, $param);
        } else if(method_exists($connection,'fetchAssoc')){
            $count = $connection->fetchAssoc($sql, $param);
        } else {
            $count = false;
        }
		return $count['COUNT(*)'] >= 1;
	}
}
