<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Result;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1694783181StatusMailAdditional extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1694783181;
    }

    public function update(Connection $connection): void
    {
	    $this->updateAdditionalMessage20($connection);
    }

	/**
	 * @param Connection $oConnection Database connection, default Doctrine stuff
	 * @return void
	 * @throws Exception Regular Doctrine stuff
	 */
	private function updateAdditionalMessage20(Connection $oConnection)
	{
		$sID = md5('sCreditplusOrderAdditionalMessage20');
		$oRes = $oConnection->executeQuery("SELECT HEX(mtt.mail_template_id) AS mail_template_id, HEX(mtt.language_id) AS language_id, mtt.content_html, mtt.content_plain 
		FROM mail_template_translation mtt 
		    INNER JOIN mail_template mt ON mtt.mail_template_id = mt.id 
		    INNER JOIN mail_template_type mttype ON mt.mail_template_type_id = mttype.id
		WHERE mt.id = UNHEX('$sID')");
		$sOldContentPlain = $this->getOldContent('sCreditplusOrderAdditionalMessage_20_plain');
		$sOldContentHtml = $this->getOldContent('sCreditplusOrderAdditionalMessage_20_html');
		$sNewContentPlain = $this->getNewContent('sCreditplusOrderAdditionalMessage_20_plain');
		$sNewContentHtml = $this->getNewContent('sCreditplusOrderAdditionalMessage_20_html');
		$this->updateTemplatesWithParams($oConnection, 'Bestellmail für CreditPlus bei ausstehender Entscheidung', $sOldContentPlain, $sOldContentHtml, $sNewContentPlain, $sNewContentHtml, $oRes);
	}

	/**
	 * @param Connection $oConnection Database connection, default Doctrine stuff
	 * @param string|boolean $sNewTitle New title for mail template
	 * @param string|boolean $sOldContentPlain Old Plain content for mail templates (must match database value)
	 * @param string|boolean $sOldContentHtml Old HTML content for mail templates (must match database value)
	 * @param string|boolean $sNewContentPlain New Plain content for mail templates
	 * @param string|boolean $sNewContentHtml New HTML content for mail templates
	 * @param Result $oRes The mail templates to be updated
	 * @return void
	 * @throws Exception Regular Doctrine stuff
	 */
	private function updateTemplatesWithParams(Connection $oConnection, $sNewTitle, $sOldContentPlain, $sOldContentHtml, $sNewContentPlain, $sNewContentHtml, $oRes)
	{
		// Old and new texts may not be empty
		if ( !$sOldContentPlain ) {
			return;
		}
		if ( !$sOldContentHtml ) {
			return;
		}
		if ( !$sNewContentPlain ) {
			return;
		}
		if ( !$sNewContentHtml ) {
			return;
		}
		while ( $aRow = $oRes->fetchAssociative() ) {
			if ( trim(str_replace(["\r","\n"], ['',''], $aRow['content_html'])) !== trim(str_replace(["\r","\n"], ['',''], $sOldContentHtml)) ) {
				// Old content must be identical in the database
				continue;
			}
			if ( trim(str_replace(["\r","\n"], ['',''], $aRow['content_plain'])) !== trim(str_replace(["\r","\n"], ['',''], $sOldContentPlain)) ) {
				// Old content must be identical in the database
				continue;
			}
			$aUpdateParams = [
				'description' => $sNewTitle,
				'contentHtml' => $sNewContentHtml,
				'contentPlain' => $sNewContentPlain,
				'mailTemplateId' => $aRow['mail_template_id'],
				'languageId' => $aRow['language_id']
			];
			$oConnection->executeStatement("UPDATE mail_template_translation SET description = :description, content_html = :contentHtml, content_plain = :contentPlain WHERE mail_template_id = UNHEX(:mailTemplateId) AND language_id = UNHEX(:languageId)", $aUpdateParams);
		}
	}

	private function getOldContent($sFileName) {
		$sDir = dirname(__DIR__).'/DefaultMails/Update_1_2_30/';
		if ( file_exists($sDir.$sFileName.'.html.twig') ) {
			return file_get_contents($sDir.$sFileName.'.html.twig');
		}
		return '';
	}

	private function getNewContent($sFileName) {
		$sDir = dirname(__DIR__).'/DefaultMails/';
		if ( file_exists($sDir.$sFileName.'.html.twig') ) {
			return file_get_contents($sDir.$sFileName.'.html.twig');
		}
		return '';
	}

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
