<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception as DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1724334921UpdateBrokenTransactionNumbers extends MigrationStep
{
	public function getCreationTimestamp(): int
	{
		return 1724334921;
	}

	/**
	 * Updates the orderNumber value for orders where the transactionNumber should have been sent in
	 *
	 * @param Connection $connection
	 * @return void
	 * @throws DBALException
	 */
	public function update(Connection $connection): void
	{
		try {
			$oResult = $connection->executeQuery("SELECT * FROM sico_credit_plus_payment WHERE NOT (url LIKE CONCAT('%don=', orderNumber,'%'));");
		} catch ( DBALException $e ) {
			$oResult = false;
		}
		if ( $oResult && $oResult->rowCount() ) {
			while ( $aRow = $oResult->fetchAssociative() ) {
				$sOrderNumber = '';
				$sURL = $aRow['url'];
				if ( $sURL ) {
					$aURL = parse_url($sURL);
					$sQueryString = $aURL['query'];
					if ( $sQueryString && (strpos($sQueryString, 'don=') !== false) ) {
						$aQueryString = explode('&', $sQueryString);
						foreach ( $aQueryString as $sQueryPart ) {
							$aQueryPart = explode('=', $sQueryPart);
							if ( $aQueryPart[0] == 'don' ) {
								$sOrderNumber = $aQueryPart[1];
							}
						}
					}
					if ( $sOrderNumber ) {
						$connection->executeStatement("UPDATE sico_credit_plus_payment SET orderNumber = :orderNumber WHERE id = :id", ['orderNumber' => $sOrderNumber, 'id' => $aRow['id']]);
					}
				}
			}
		}
	}

	public function updateDestructive(Connection $connection): void
	{
		// implement update destructive
	}
}
