import template from './cp-clear-cache-btn.html.twig';

const { Component } = Shopware;

Component.register('cp-clear-cache-btn',{
    template:template,
    inject:['cacheApiService'],
    data(){
        return {
            isLoading: false,
            isSaveSuccessful: false
        }
    },
    methods:{
        onClick(){
            this.isLoading = true;
            this.cacheApiService.clear().then(() => {
                this.isLoading = false;
                this.isSaveSuccessful = true;
                window.setTimeout(()=>{this.isSaveSuccessful = false},2000);
            });
        }
    }
});
