import template from './cp-productgroup-detail-base.html.twig';
import prodGroupState from './../../page/cp-prodgroup-detail/state';
import './../../page/cp-prodgroup-detail';

const { Component, Mixin, Context, Store } = Shopware;
const { Criteria,EntityCollection } = Shopware.Data;
const { mapPageErrors, mapState, mapGetters } = Shopware.Component.getComponentHelper();

Shopware.Component.register('cp-productgroup-detail-base',{
    template: template,
    data(){
        return {
            //prodgroup: null,
            isLoading:false,
            isSaveSuccessful: false,
            isSaveSuccessfulAddRate:false,
            sortBy: 'sicoInterest',
            sortDirection: 'DESC',
            salesChannels:[],
            dynamicProductGroups:[],
            localProdgroupId: null,
            prodgroup: null,
            offeredOptions: null
        }
    },
    props: {
        prodgroupId: {
            type: String,
            required: false,
            default: null
        }
    },
    mixins: [
        Mixin.getByName('listing')
    ],
    inject: ['repositoryFactory', 'cacheApiService'],
    computed:{
        ...mapState('cpProdGroupState',['prodgroupId','prodgroup','offeredOptions']),
        columns(){
            return [
                {property: 'sicoMonths',label:'Monate',rawData:true,inlineEdit:'number',sortable:true},
                {property: 'sicoInterest',label:'Effektiver Jahreszins',rawData:true,inlineEdit:'number',sortable:true},
                {property: 'sicoProdcode',label:'Produkt Code',rawData:true,inlineEdit:'string',sortable:true},
                {property: 'sicoActive',label:'Aktiv',rawData:true,inlineEdit:'boolean',sortable:true},
                {property: 'sicoRatefactor',label:'Ratenfaktor',rawData:true,inlineEdit:'number',sortable:true},
            ];
        },
        prodgroupRepository() {
            return this.repositoryFactory.create('sico_productgroup');
        },
        prodgroupCriteria(){
            let criteria = new Criteria();
            // criteria.addAssociation('product');
            criteria.addAssociation('prodgroupSalesChannel');
            criteria.addAssociation('dynamicProductGroup');
            return criteria;
        },
        offeredOptionRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
        salesChannelRepository(){
            return this.repositoryFactory.create('sales_channel');
        },
        dynamicProductGroupRepository(){
            return this.repositoryFactory.create('product_stream');
        },
        salesChannelIds: {
            get(){
                if(!this.prodgroup){
                    return [];
                }
                if(!this.prodgroup.prodgroupSalesChannel){
                    return [];
                }
                return this.prodgroup.prodgroupSalesChannel.map((salesChannel) => {
                    return salesChannel.salesChannelId;
                })
            },
            set(salesChannelsIds){
                salesChannelsIds = salesChannelsIds || [];
                const { deleted, added } = this.getChangeset(salesChannelsIds);
                if (this.prodgroup.isNew()) {
                    this.handleLocalMode(deleted, added);
                    return;
                }
                this.handleWithRepository(deleted, added);
            },
        },
        prodgroupSalesChannelRepository(){
            if(this.prodgroup){
                return this.repositoryFactory.create(
                    this.prodgroup.prodgroupSalesChannel.entity,
                    this.prodgroup.prodgroupSalesChannel.source,
                );
            }
            return null;
        },
        salesChannelCriteria() {
            const salesChannelCriteria = new Criteria(1, 500);
            salesChannelCriteria.addSorting(Criteria.sort('name', 'ASC', this.naturalSorting));

            return salesChannelCriteria;
        },
        dynamicProductGroupCriteria() {
            const dynamicProductGroupCriteria = new Criteria(1, 500);
            dynamicProductGroupCriteria.addSorting(Criteria.sort('name', 'ASC', this.naturalSorting));

            return dynamicProductGroupCriteria;
        },
    },
    created() {
        Shopware.State.registerModule('cpProdGroupState', prodGroupState);
        this.isLoading = true;
        let prodgroupId = this.$route.params.id;
        this.localProdgroupId = prodgroupId;

        if(this.localProdgroupId !== null && this.localProdgroupId !== undefined){
            this.prodgroupRepository.get(prodgroupId,Shopware.Context.api,this.prodgroupCriteria).then((res) => {
                Shopware.State.commit('cpProdGroupState/setProdgroup', res);
                Shopware.State.commit('cpProdGroupState/setProdgroupId',prodgroupId);
                this.prodgroup = res;
            });
            this.offeredOptionRepository.search(this.offeredOptionsCriteria(prodgroupId),Shopware.Context.api).then((res) => {
                Shopware.State.commit('cpProdGroupState/setOfferedOptions',res);
                this.offeredOptions = res;
                this.isLoading = false;
            });
        }
        else {
            this.prodgroup = this.prodgroupRepository.create(Shopware.Context.api);
            Shopware.State.commit('cpProdGroupState/setProdgroup', this.prodgroup);
            this.isLoading = false;
        }
        this.createdComponent();
    },
    methods:{
        offeredOptionsCriteria(prodgroupId){
            let criteria = new Criteria();
            if(prodgroupId) {
                criteria.addFilter(Criteria.equals('sicoProdgroupId', prodgroupId));
            }
            criteria.addSorting(Criteria.sort('sicoMonths', 'ASC'));
            return criteria;
        },
        createdComponent() {
            this.salesChannelRepository
                .search(this.salesChannelCriteria)
                .then(searchresult => {
                    this.salesChannels = searchresult;
                });
            this.dynamicProductGroupRepository
                .search(this.dynamicProductGroupCriteria)
                .then(searchresult => {
                    this.dynamicProductGroups = searchresult
                });
        },
        onSave(){
            this.isLoading = true;
            this.prodgroupRepository.save(this.prodgroup,Shopware.Context.api).then(() => {
                this.isLoading = false;
                this.isSaveSuccessful = true;
                //this.$router.push({name:'sico.creditplus.prodgroupDetail', params:{id:this.prodgroup.id}});
                Shopware.State.commit('cpProdGroupState/setProdgroupId',this.prodgroup.id);
                window.setTimeout(()=>{this.isSaveSuccessful = false},2000);
                this.cacheApiService.clear().then();
            });

        },
        addRate(){
            this.isLoading = true;
            let offeredOption = this.offeredOptionRepository.create(Shopware.Context.api);
            offeredOption.sicoMonths = 6;
            offeredOption.sicoInterest = 0.0;
            offeredOption.sicoProdcode = "Standard";
            offeredOption.sicoActive = false;
            offeredOption.sicoRatefactor = -1;
            offeredOption.sicoProdgroup = this.prodgroup;
            offeredOption.sicoProdgroupId = this.prodgroup.id;
            this.offeredOptionRepository.save(offeredOption,Shopware.Context.api).then(() => {
                Shopware.State.commit('cpProdGroupState/addOfferedOption', offeredOption);
                this.offeredOptionRepository.search(this.offeredOptionsCriteria(this.localProdgroupId),Shopware.Context.api).then((res) => {
                    Shopware.State.commit('cpProdGroupState/setOfferedOptions',res);
                    this.offeredOptions = res;
                    this.isLoading = false;
                });

                this.isLoading = false;
                this.isSaveSuccessfulAddRate = true;
                window.setTimeout(()=>this.isSaveSuccessfulAddRate = false,2000);
            })

        },
        removeRate(item){
            this.offeredOptionRepository.delete(item.id,Shopware.Context.api).then(() => {
                Shopware.State.commit('cpProdGroupState/deleteOfferedOption',item);
                this.offeredOptions = this.offeredOptions.filter(opt => opt.id !== item.id);
            });
        },
        updateRate(item){
            //console.log(item);
            this.offeredOptionRepository.save(item,Shopware.Context.api).then(() => {});
        },
        getList(){
            /*
            this.isLoading = true;
            const criteria = new Criteria(this.);
            this.getOfferedOptionRepository.search()
            */
        },
        // --------------------------- Multi Select Field ----------------------------
        getChangeset(salesChannelsIds) {
            const deleted = [];
            const added = [];
            salesChannelsIds.forEach((id) => {
                const foundSalesChannel = this.prodgroup.prodgroupSalesChannel.find((salesChannel) => {
                    return salesChannel.salesChannelId === id;
                });

                if(!foundSalesChannel){
                    added.push(id);
                }
            });
            this.prodgroup.prodgroupSalesChannel.forEach((salesChannel) => {
                if (!salesChannelsIds.includes(salesChannel.salesChannelId)) {
                    deleted.push(salesChannel.salesChannelId);
                }
            });
            return { deleted, added };
        },
        getAssociationBySalesChannelId(salesChannelId) {
            return this.prodgroup.prodgroupSalesChannel.find((association) => {
                return association.salesChannelId === salesChannelId;
            });
        },
        handleLocalMode(deleted, added) {
            deleted.forEach((deletedId) => {
                const collectionEntry = this.getAssociationBySalesChannelId(deletedId);
                this.prodgroup.prodgroupSalesChannel.remove(collectionEntry.id);
            });
            added.forEach((newId) => {
                const newAssociation = this.prodgroupSalesChannelRepository.create(this.prodgroup.prodgroupSalesChannel.context);

                newAssociation.salesChannelId = newId;
                newAssociation.productgroupId = this.prodgroup.id;
                this.prodgroup.prodgroupSalesChannel.add(newAssociation);
            });
        },
        handleWithRepository(deleted,added){
            deleted.forEach((deletedId) => {
                const collectionEntry = this.getAssociationBySalesChannelId(deletedId);
                this.prodgroup.prodgroupSalesChannel.remove(collectionEntry.id);
            });
            added.forEach((newId) => {
                const newAssociation = this.prodgroupSalesChannelRepository.create(this.prodgroup.prodgroupSalesChannel.context);

                newAssociation.salesChannelId = newId;
                newAssociation.productgroupId = this.prodgroup.id;
                this.prodgroup.prodgroupSalesChannel.add(newAssociation);
            });
        },
        setIds(salesChannels){
            this.salesChannels=salesChannels;
            //this.prodgroup.prodgroupSalesChannel = salesChannels;
        }
    }
});
