const ApiService = Shopware.Classes.ApiService;
/**
 * Gateway for the API end point "recommenations"
 * @class
 * @extends ApiService
 */
export default class CpContractApiService extends ApiService {
    /**
     * @constructor
     * @param {AxiosInstance} httpClient
     * @param {LoginService} loginService
     * @param {String} apiEndpoint
     */
    constructor(httpClient, loginService, apiEndpoint = 'sico') {
        super(httpClient, loginService, apiEndpoint);
    }

    getContract(orderId) {
        const route = '/sico/contract-data/' + orderId;
        const headers = this.getBasicHeaders();
        return this.httpClient.get(route,{headers},{});
    }

    sendOrder(orderId) {
        const route = '/sico/send-order/' + orderId;
        const headers = this.getBasicHeaders();
        return this.httpClient.patch(route,{},{headers});
    }

    cancelOrder(orderId) {
        const route = '/sico/cancel-order/' + orderId;
        const headers = this.getBasicHeaders();
        return this.httpClient.patch(route,{},{headers});
    }
    changePaymentMethod(orderId, paymentMethodId) {
        const route = '/sico/change-payment-method-order/' + orderId + '/' + paymentMethodId;
        const headers = this.getBasicHeaders();
        return this.httpClient.patch(route,{},{headers});
    }

    updateOrders(orders){
        const route = '/sico/update-orders/';
        const headers = this.getBasicHeaders();
        return this.httpClient.patch(route,{orders: orders},{headers});
    }
}
