<?php
/**
 * Created by PhpStorm.
 * User: philipp.holzmann
 * Date: 26.07.2021
 * Time: 08:10
 */
namespace SicoCreditPlus\Core\Content\Order;

use Shopware\Core\Checkout\Order\OrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\CreditPlusPayment\CreditPlusPaymentDefinition;

class OrderExtension extends EntityExtension
{
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            (new OneToManyAssociationField(
                'creditPlusPayment',
                CreditPlusPaymentDefinition::class,
                'order_id'))->addFlags(new CascadeDelete())
        );
    }

    public function getEntityName(): string
    {
        return OrderDefinition::ENTITY_NAME;
    }
}
