<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 23.01.2020
 * Time: 15:56
 */

namespace SicoCreditPlus\Core\Content\Product;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\ApiAware;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Inherited;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoCreditPlusCalculatedRate\SicoCreditPlusCalculatedRateDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroupProducts\SicoProductgroupProductsDefinition;

class ProductExtension extends EntityExtension {
	public function extendFields(FieldCollection $collection): void
	{
		$collection->add(
			(new ManyToManyAssociationField(
				'prodgroups',
				SicoProductgroupDefinition::class,
				SicoProductgroupProductsDefinition::class,
				'product_id',
				'productgroup_id'))->addFlags(new Inherited())
		);
		$collection->add((new OneToManyAssociationField(
			'sicoCreditPlusCalculatedRates',
			SicoCreditPlusCalculatedRateDefinition::class,
			'product_id',
			'id'
		))->addFlags(new ApiAware()));
	}

    public function getEntityName(): string
    {
        return ProductDefinition::ENTITY_NAME;
    }
}
