<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 04.01.2024
 * @time 13:20
 */

namespace SicoCreditPlus\Core\Content\ProductStream;

use Shopware\Core\Content\ProductStream\ProductStreamDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use SicoCreditPlus\Core\Content\SicoProductgroup\SicoProductgroupDefinition;

class ProductStreamExtension extends EntityExtension
{
	public function extendFields(FieldCollection $collection): void
	{
		$collection->add(
			(new OneToManyAssociationField(
				'sicoProductGroup',
				SicoProductgroupDefinition::class,
				'id'))->addFlags(new CascadeDelete())
		);
	}

    public function getEntityName(): string
    {
        return ProductStreamDefinition::ENTITY_NAME;
    }
}
