<?php

namespace SicoCreditPlus\Core\Content\SalesChannel;


use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\CascadeDelete;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;
use SicoCreditPlus\Core\Content\SicoProductgroupSalesChannel\SicoProductgroupSalesChannelDefinition;

class SalesChannelExtension extends EntityExtension {
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            (new OneToManyAssociationField(
                'prodgroupSalesChannel',
                SicoProductgroupSalesChannelDefinition::class,
                'productgroup_id'))->addFlags(new CascadeDelete())
        );
    }

    public function getEntityName(): string
    {
        return SalesChannelDefinition::ENTITY_NAME;
    }
}
