<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 24.06.2024
 * @time 11:30
 */

namespace SicoCreditPlus\Core\Content\SicoCreditPlusCalculatedRate;

use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Shopware\Core\System\Currency\CurrencyEntity;
use Shopware\Core\System\SalesChannel\SalesChannelEntity;

class SicoCreditPlusCalculatedRateEntity extends Entity
{
	use EntityIdTrait;

	/**
	 * @var string $productId
	 * Since the cheapest rate is provided by sales channel, this entity must attach to the product.
	 */
	protected string $productId = '';

	/**
	 * @var string $productVersionId
	 * This field is not used in the calculation, but it is used to link the product to the calculated rate.
	 */
	protected string $productVersionId = '';

	/**
	 * @var ?ProductEntity $sicoProduct
	 * This is the object referenced by $sicoProductId
	 */
	protected ?ProductEntity $sicoProduct = null;

	/**
	 * @var string $sicoSalesChannelId
	 * This field needs to be checked when calculating the cheapest rate too.
	 */
	protected string $sicoSalesChannelId = '';

	/**
	 * @var ?SalesChannelEntity $sicoSalesChannel
	 * This is the object referenced by the $sicoSalesChannelId
	 */
	protected ?SalesChannelEntity $sicoSalesChannel = null;

	/**
	 * @var int $sicoMinMonths
	 * The minimum months this product can be financed for
	 */
	protected int $sicoMinMonths = -1;

	/**
	 * @var float $sicoMinMonthsInterestRate
	 * The effective yearly interest value that accompanies the $sicoMinMonths
	 */
	protected float $sicoMinMonthsInterestRate = -1.0;

	/**
	 * @var float $sicoMinMonthsRate
	 * The calculated monthly payment that accompanies the $sicoMinMonths
	 */
	protected float $sicoMinMonthsRate = -1.0;

	/**
	 * @var int $sicoMaxMonths
	 * The maximum number of months this product may be financed for
	 */
	protected int $sicoMaxMonths = -1;

	/**
	 * @var float $sicoMaxMonthsInterestRate
	 * The effective yearly interest value that accompanies the $sicoMaxMonths
	 */
	protected float $sicoMaxMonthsInterestRate = -1.0;

	/**
	 * @var float $sicoMaxMonthsRate
	 * The calculated monthly payment that accompanies the $sicoMaxMonths
	 */
	protected float $sicoMaxMonthsRate = -1.0;

	/**
	 * @var int $sicoAbsoluteMinRateMonths
	 * The amount of months that accompanies the $sicoAbsoluteMinRateRate
	 */
	protected int $sicoAbsoluteMinRateMonths = -1;

	/**
	 * @var float $sicoAbsoluteMinRateInterestRate
	 * The effective yearly interest value that accompanies the $sicoAbsoluteMinRateRate
	 */
	protected float $sicoAbsoluteMinRateInterestRate = -1.0;

	/**
	 * @var float $sicoAbsoluteMinRateRate
	 * This is the lowest rate the product may be financed for as a solo product
	 */
	protected float $sicoAbsoluteMinRateRate = -1.0;

	/**
	 * @var int $sicoFictionalMinRateMonths
	 * The amount of months that accompanies the $sicoFictionalMinRateRate
	 */
	protected int $sicoFictionalMinRateMonths = -1;

	/**
	 * @var float $sicoFictionalMinRateInterestRate
	 * The effective yearly interest value that accompanies the $sicoFictionalMinRateRate
	 */
	protected float $sicoFictionalMinRateInterestRate = -1.0;

	/**
	 * @var float $sicoFictionalMinRateRate
	 * This is the lowest rate the product may be financed for as part of a basket (ignoring the minimum financing rate)
	 */
	protected float $sicoFictionalMinRateRate = -1.0;

	/**
	 * @var bool|null $sicoCalculationFinished
	 * If this value is null or false, the calculation needs to run again.
	 */
	protected ?bool $sicoCalculationFinished = null;

	/**
	 * @var string $sicoCurrencyId
	 * The ID that leads to the object defined at $sicoCurrency
	 */
	protected string $sicoCurrencyId = '';

	/**
	 * @var ?CurrencyEntity $sicoCurrency
	 * Just the currency entity linked to all the rates (usually EUR)
	 */
	protected ?CurrencyEntity $sicoCurrency = null;

	/**
	 * @return string
	 */
	public function getProductId(): string
	{
		return $this->productId;
	}

	/**
	 * @param string $productId
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setProductId(string $productId): SicoCreditPlusCalculatedRateEntity
	{
		$this->productId = $productId;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getProductVersionId(): string
	{
		return $this->productVersionId;
	}

	/**
	 * @param string $productVersionId
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setProductVersionId(string $productVersionId): SicoCreditPlusCalculatedRateEntity
	{
		$this->productVersionId = $productVersionId;
		return $this;
	}

	/**
	 * @return ?ProductEntity
	 */
	public function getSicoProduct(): ?ProductEntity
	{
		return $this->sicoProduct;
	}

	/**
	 * @param ?ProductEntity $sicoProduct
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoProduct(?ProductEntity $sicoProduct): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoProduct = $sicoProduct;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getSicoSalesChannelId(): string
	{
		return $this->sicoSalesChannelId;
	}

	/**
	 * @param string $sicoSalesChannelId
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoSalesChannelId(string $sicoSalesChannelId): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoSalesChannelId = $sicoSalesChannelId;
		return $this;
	}

	/**
	 * @return ?SalesChannelEntity
	 */
	public function getSicoSalesChannel(): ?SalesChannelEntity
	{
		return $this->sicoSalesChannel;
	}

	/**
	 * @param ?SalesChannelEntity $sicoSalesChannel
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoSalesChannel(?SalesChannelEntity $sicoSalesChannel): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoSalesChannel = $sicoSalesChannel;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getSicoMinMonths(): int
	{
		return $this->sicoMinMonths;
	}

	/**
	 * @param int $sicoMinMonths
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMinMonths(int $sicoMinMonths): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMinMonths = $sicoMinMonths;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoMinMonthsInterestRate(): float
	{
		return $this->sicoMinMonthsInterestRate;
	}

	/**
	 * @param float $sicoMinMonthsInterestRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMinMonthsInterestRate(float $sicoMinMonthsInterestRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMinMonthsInterestRate = $sicoMinMonthsInterestRate;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoMinMonthsRate(): float
	{
		return $this->sicoMinMonthsRate;
	}

	/**
	 * @param float $sicoMinMonthsRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMinMonthsRate(float $sicoMinMonthsRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMinMonthsRate = $sicoMinMonthsRate;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getSicoMaxMonths(): int
	{
		return $this->sicoMaxMonths;
	}

	/**
	 * @param int $sicoMaxMonths
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMaxMonths(int $sicoMaxMonths): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMaxMonths = $sicoMaxMonths;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoMaxMonthsInterestRate(): float
	{
		return $this->sicoMaxMonthsInterestRate;
	}

	/**
	 * @param float $sicoMaxMonthsInterestRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMaxMonthsInterestRate(float $sicoMaxMonthsInterestRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMaxMonthsInterestRate = $sicoMaxMonthsInterestRate;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoMaxMonthsRate(): float
	{
		return $this->sicoMaxMonthsRate;
	}

	/**
	 * @param float $sicoMaxMonthsRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoMaxMonthsRate(float $sicoMaxMonthsRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoMaxMonthsRate = $sicoMaxMonthsRate;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getSicoAbsoluteMinRateMonths(): int
	{
		return $this->sicoAbsoluteMinRateMonths;
	}

	/**
	 * @param int $sicoAbsoluteMinRateMonths
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoAbsoluteMinRateMonths(int $sicoAbsoluteMinRateMonths): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoAbsoluteMinRateMonths = $sicoAbsoluteMinRateMonths;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoAbsoluteMinRateInterestRate(): float
	{
		return $this->sicoAbsoluteMinRateInterestRate;
	}

	/**
	 * @param float $sicoAbsoluteMinRateInterestRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoAbsoluteMinRateInterestRate(float $sicoAbsoluteMinRateInterestRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoAbsoluteMinRateInterestRate = $sicoAbsoluteMinRateInterestRate;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoAbsoluteMinRateRate(): float
	{
		return $this->sicoAbsoluteMinRateRate;
	}

	/**
	 * @param float $sicoAbsoluteMinRateRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoAbsoluteMinRateRate(float $sicoAbsoluteMinRateRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoAbsoluteMinRateRate = $sicoAbsoluteMinRateRate;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getSicoFictionalMinRateMonths(): int
	{
		return $this->sicoFictionalMinRateMonths;
	}

	/**
	 * @param int $sicoFictionalMinRateMonths
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoFictionalMinRateMonths(int $sicoFictionalMinRateMonths): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoFictionalMinRateMonths = $sicoFictionalMinRateMonths;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoFictionalMinRateInterestRate(): float
	{
		return $this->sicoFictionalMinRateInterestRate;
	}

	/**
	 * @param float $sicoFictionalMinRateInterestRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoFictionalMinRateInterestRate(float $sicoFictionalMinRateInterestRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoFictionalMinRateInterestRate = $sicoFictionalMinRateInterestRate;
		return $this;
	}

	/**
	 * @return float
	 */
	public function getSicoFictionalMinRateRate(): float
	{
		return $this->sicoFictionalMinRateRate;
	}

	/**
	 * @param float $sicoFictionalMinRateRate
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoFictionalMinRateRate(float $sicoFictionalMinRateRate): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoFictionalMinRateRate = $sicoFictionalMinRateRate;
		return $this;
	}

	/**
	 * @return bool|null
	 */
	public function getSicoCalculationFinished(): ?bool
	{
		return $this->sicoCalculationFinished;
	}

	/**
	 * @param bool|null $sicoCalculationFinished
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoCalculationFinished(?bool $sicoCalculationFinished = true): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoCalculationFinished = $sicoCalculationFinished;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getSicoCurrencyId(): string
	{
		return $this->sicoCurrencyId;
	}

	/**
	 * @param string $sicoCurrencyId
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoCurrencyId(string $sicoCurrencyId): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoCurrencyId = $sicoCurrencyId;
		return $this;
	}

	/**
	 * @return ?CurrencyEntity
	 */
	public function getSicoCurrency(): ?CurrencyEntity
	{
		return $this->sicoCurrency;
	}

	/**
	 * @param ?CurrencyEntity $sicoCurrency
	 * @return SicoCreditPlusCalculatedRateEntity
	 */
	public function setSicoCurrency(?CurrencyEntity $sicoCurrency): SicoCreditPlusCalculatedRateEntity
	{
		$this->sicoCurrency = $sicoCurrency;
		return $this;
	}
}
