<?php
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 18.02.2020
 * Time: 16:57
 */

namespace SicoCreditPlus\Errors;

use Shopware\Core\Checkout\Cart\Error\Error;
use Throwable;

class CreditPlusNotAvailableError extends Error{

	private const KEY = 'creditplus-not-available';

	public function __construct(string $message = "", int $code = 0, Throwable $previous = null)
	{
		parent::__construct($message, $code, $previous);
	}

	public function getId(): string
	{
		return self::KEY.'-'.date('d-m-y H:i');
	}

	public function getMessageKey(): string
	{
		//return self::KEY;
		return 'creditplusNotAvailable';
	}

	public function getLevel(): int
	{
		return self::LEVEL_ERROR;
	}

	public function blockOrder(): bool
	{
		return false;
	}

	public function getParameters(): array
	{
		return [];
	}
}
