<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\InheritanceUpdaterTrait;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1618475073InorderMigration2 extends MigrationStep
{
	use InheritanceUpdaterTrait;
    public function getCreationTimestamp(): int
    {
        return 1618475073;
    }

    public function update(Connection $connection): void
    {
    	$sql = 'SHOW COLUMNS FROM sico_credit_plus_payment';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasOrderIdNull = false;
		$bHasTokenColumn = false;
		foreach($fields as $field){
			if($field['Field'] ==='order_id' && $field['Null'] === 'Yes'){
				$bHasOrderIdNull = true;
			}
			if($field['Field'] ==='token'){
				$bHasTokenColumn = true;
			}

		}
		if(!$bHasOrderIdNull){
			$sql = 'ALTER TABLE sico_credit_plus_payment MODIFY order_id binary(16) null';
			$connection->executeStatement($sql);
		}
		if(!$bHasTokenColumn){
			$sql = 'ALTER TABLE sico_credit_plus_payment ADD COLUMN token varchar(255) null';
			$connection->executeStatement($sql);
		}
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
