<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1620313266finishUrlExtension extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1620313266;
    }

    public function update(Connection $connection): void
    {
		$sql = 'SHOW COLUMNS FROM sico_credit_plus_payment';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasOrderFinishExtendedSize = false;
		foreach($fields as $field){
			if($field['Field'] === 'order_finish' && $field['Type'] === 'varchar(400)'){
				$bHasOrderFinishExtendedSize = true;
			}
		}
		if(!$bHasOrderFinishExtendedSize){
			$sql = 'ALTER TABLE sico_credit_plus_payment MODIFY order_finish varchar(400)';
			$connection->executeStatement($sql);
		}
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
