<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1704358942DynamicGroups extends MigrationStep
{
	public function getCreationTimestamp(): int
	{
		return 1704358942;
	}

	public function update(Connection $connection): void
	{
		// implement update
		$sql = 'SHOW COLUMNS FROM sico_productgroup';
		$resultStatement = $connection->executeQuery($sql);
		$fields = $resultStatement->fetchAllAssociative();
		$bHasStream = false;
		foreach ( $fields as $field ) {
			if ( $field['Field'] === 'dynamic_product_group' ) {
				$bHasStream = true;
			}
		}
		if ( !$bHasStream ) {
			$connection->executeStatement('ALTER TABLE `sico_productgroup` ADD COLUMN `dynamic_product_group` binary(16) NULL DEFAULT NULL');
			$connection->executeStatement('ALTER TABLE `sico_productgroup` ADD FOREIGN KEY sico_pg_stream (dynamic_product_group) REFERENCES product_stream (id)');
		}
	}

	public function updateDestructive(Connection $connection): void
	{
		// implement update destructive
	}
}
