<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Content\Flow\Dispatching\Struct\ActionSequence;
use Shopware\Core\Content\Flow\Dispatching\Struct\Flow;
use Shopware\Core\Framework\Migration\MigrationStep;
use Shopware\Core\Framework\Uuid\Uuid;

class Migration1716463919FlowBasedDelivery extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1716463919;
    }

    public function update(Connection $connection): void
    {
        // implement update
		$oResult = $connection->executeQuery("SELECT id, payload FROM flow WHERE `event_name` = 'state_enter.order_delivery.state.shipped'");
		$aRow = $oResult->fetchAssociative();
		$sFlowID = $aRow['id'];
		$sID = Uuid::randomBytes();
		$iDisplayGroup = 1;
		$oGroupsResult = $connection->executeQuery('SELECT MAX(display_group) as max_display_group FROM flow_sequence WHERE flow_id = :flow_id', ['flow_id' => $sFlowID]);
		$aGroupsRow = $oGroupsResult->fetchAssociative();
		if ( $aGroupsRow['max_display_group'] ) {
			$iDisplayGroup = $aGroupsRow['max_display_group'] + 1;
		}
		$connection->executeStatement('INSERT INTO flow_sequence (
                           id, flow_id, app_flow_action_id, 
                           parent_id, rule_id, action_name, config, 
                           position, display_group, true_case, 
                           custom_fields, created_at, updated_at) VALUES 
					  (
					   		:id, :flow_id, :app_flow_action_id, 
					   		:parent_id, :rule_id, :action_name, :config, 
							:position, :display_group, :true_case, 
					   		:custom_fields, :created_at, :updated_at)', [
			'id' => $sID,
			'flow_id' => $sFlowID,
			'app_flow_action_id' => null,
			'parent_id' => null,
			'rule_id' => null,
			'action_name' => 'action.creditplus.dispatched',
			'config' => '[]',
			'position' => 1,
			'display_group' => $iDisplayGroup,
			'true_case' => 0,
			'custom_fields' => null,
			'created_at' => (new \DateTime())->format('Y-m-d H:i:s'),
			'updated_at' => (new \DateTime())->format('Y-m-d H:i:s')
		]);

		// This is incredibly stupid, but we have to fill a
		// serialized value into the parent element to make use of the added sequence.
		// This only happens because Shopware does not understand relational databases.
        $sSerialized = $aRow['payload'];
		/** @var Flow $oFlowStruct */
		$oFlowStruct = @unserialize($sSerialized);
		// If pre-6.6, do
		if ( $oFlowStruct ) {
			$aSequences = $oFlowStruct->getSequences();
			$oActionSequence = ActionSequence::createAction(
				'action.creditplus.dispatched',
				null,
				$sFlowID,
				$sID
			);
			$aSequences[] = $oActionSequence;
			$oFlowStruct->assign(['sequences' => $aSequences]);
			$sSerialized = serialize($oFlowStruct);
			$connection->executeStatement('UPDATE flow SET payload = :payload WHERE id = :id', ['payload' => $sSerialized, 'id' => $sFlowID]);
		}
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
