<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception as DBALException;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
class Migration1730712297DeleteCascade extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1730712297;
    }

    public function update(Connection $connection): void
    {
		try {
			// Drop constraint for MariaDB
			$connection->executeStatement("
				ALTER TABLE sico_credit_plus_calculated_rate
				DROP CONSTRAINT sico_credit_plus_calculated_rate_ibfk_3;
			");
			// Recreate with cascading
			$connection->executeStatement("
				ALTER TABLE sico_credit_plus_calculated_rate
				ADD CONSTRAINT sico_credit_plus_calculated_rate_ibfk_3
				FOREIGN KEY (`product_id`) REFERENCES `product` (`id`)
				ON DELETE CASCADE ON UPDATE CASCADE;
			");
		} catch ( DBALException $oException ) {
			if ( $oException->getCode() == 1064 ) {
				// Drop Foreign Key for MySQL Servers
				$connection->executeStatement("
					ALTER TABLE sico_credit_plus_calculated_rate
					DROP FOREIGN KEY sico_credit_plus_calculated_rate_ibfk_3;
				");
				// Recreate with cascading
				$connection->executeStatement("
					ALTER TABLE sico_credit_plus_calculated_rate
					ADD CONSTRAINT sico_credit_plus_calculated_rate_ibfk_3
					FOREIGN KEY (`product_id`) REFERENCES `product` (`id`)
					ON DELETE CASCADE ON UPDATE CASCADE;
				");
			}
			// Do nothing
		}
    }
}
