<?php declare(strict_types=1);

namespace SicoCreditPlus\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 */
class Migration1745324597RecalculateVariants extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1745324597;
    }

    public function update(Connection $connection): void
    {
		// Mark all products with variants for recalculation
		$connection->executeStatement(
			'UPDATE sico_credit_plus_calculated_rate cr
			INNER JOIN product p ON cr.product_id = p.id AND cr.product_version_id = p.version_id
			INNER JOIN product pv ON p.id = pv.parent_id AND p.version_id = pv.version_id
			SET cr.sico_calculation_finished = 0
			WHERE cr.sico_calculation_finished = 1;');
    }
}
