import './app/component/custom-component/cp-clear-cache-btn';
import './app/component/sw-flow-sequence-action-creditplus-dispatched';
import './extension/sw-flow-sequence-action';
import './module/sico-creditplus';
import './init/CpContractApiService.init';

import template3 from './extension/cp-order-line-items-grid-override/cp-order-line-items-grid.html.twig';
import template4 from './extension/cp-order-list-override/cp-order-list-override.html.twig';
import sw_order_details_state_card_from from './extension/sw-order-details-state-card/sw-order-details-state-card.html.twig'
import sw_order_general_info from './extension/sw-order-general-info/sw-order-general-info.html.twig'
import sw_order_details_detail from './extension/sw-order-detail-details/sw-order-detail-details.html.twig'

const { Component, Mixin } = Shopware;
const { Criteria } = Shopware.Data;

Component.override('sw-order-list', {
    template: template4,

    inject: [
        'repositoryFactory',
        'stateStyleDataProviderService',
        'CpContractApi'
    ],
    methods:{
        updateContracts(){
            this.CpContractApi.updateOrders(this.orders).then(()=>{
                this.getList()
            });
        }
    }
});

Component.override('sw-order-line-items-grid',{
    template: template3,
    inject: ['repositoryFactory', 'orderService', 'acl', 'feature','CpContractApi'],
    data() {
        return {
            isLoading: false,
            selectedItems: {},
            searchTerm: '',
            nestedLineItemsModal: null,
            cpContract: null,
        };
    },
    created() {
        if(this.order.transactions.last().paymentMethod.formattedHandlerIdentifier === 'handler_sicocreditplus_creditpluspayment')
        {
            this.CpContractApi.getContract(this.order.id)
                .then(res => {
                    this.cpContract = res.data;
                    this.$emit('cp-contract-loaded',res.data);
                },reason => {
                    console.log(reason)
                });
        }
    }
});

Component.override('sw-order-detail-details',{
    template:sw_order_details_detail,

    data() {
        return {
            cpContract: null,
            isLoadingSendOrder: false,
            isLoadingCancelOrder: false,
            isLoadingPaymentMethod: false,
            sendOrderDisabled: true,
            cancelOrderDisabled: true,
            isPaymentMethodDisabled: true,
            selectedNewPaymentMethod: null,
            paymentMethodCriteria: null,
        };
    },
    mixins: [
      Mixin.getByName('notification')
    ],
    inject: [
        'CpContractApi'
    ],
    created(){
        this.paymentMethodCriteria = this.filteredPaymentMethodCriteria();
        this.CpContractApi.getContract(this.order.id).then(res => {
            this.cpContract = res.data;
            let smName = this.order.transactions.last().stateMachineState.technicalName;
            this.sendOrderDisabled =
                !(smName === 'creditplus_approved');
            this.cancelOrderDisabled =
                !(smName !== 'creditplus_cancelled');
            let paymentSwitchEnabledStates = [
                'open', // Default: open
                'creditplus_referred', // Referred
                'creditplus_accepted', // Accepted
                'creditplus_approved', // Approved
                'review_necessary', // Review necessary (unknown on CreditPlus side)
                'borrowing_request_shown', // Borrowing request shown
                'creditplus_declined_soft', // Declined (soft)
                'creditplus_declined_hard', // Declined (hard)
                'creditplus_cancelled', // Cancelled
            ];
            this.isPaymentMethodDisabled =
                (paymentSwitchEnabledStates.indexOf(smName) === -1);
        },reason => {
            console.error(reason);
        })
    },

    methods: {
        sendOrder() {
            this.isLoadingSendOrder = true;
            this.CpContractApi.sendOrder(this.orderId)
                .catch((error) => {
                    console.log(error);
                    if ( error.response && error.response.data && error.response.data.error ) {
                        this.showTranslatedErrorMessagePopup(error.response.data.error);
                    }
                    this.isLoadingSendOrder = false;
                    throw new Error('Skipping then.');
                })
                .then((res) => {
                    this.isLoadingSendOrder = false;
                    if ( res && res.data && res.data.sErrorMessage ) {
                        this.showTranslatedErrorMessagePopup(res.data.sErrorMessage);
                    } else {
                        this.sendOrderDisabled = true;
                        //this.reloadEntityData().then(() => {});
                        this.onSaveEdits();
                    }
                }).catch((error) => {
                    // Don't do anything anymore
                });
        },
        cancelOrder() {
            this.isLoadingCancelOrder = true;
            this.CpContractApi.cancelOrder(this.orderId)
                .catch((error) => {
                    //console.log(error);
                    if ( error.response && error.response.data && error.response.data.error ) {
                        this.showTranslatedErrorMessagePopup(error.response.data.error);
                    }
                    this.isLoadingCancelOrder = false;
                    throw new Error('Skipping then.');
                })
                .then((res) => {
                    this.isLoadingCancelOrder = false;
                    if (res && res.data && res.data.sErrorMessage !== undefined) {
                        //this.cpShowNotification({ title: 'Error', message: res.data.sErrorMessage });
                        this.showTranslatedErrorMessagePopup(res.data.sErrorMessage);
                        if (res.data.sError === 401) {
                            this.sendOrderDisabled = true;
                            this.cancelOrderDisabled = true;
                            //this.reloadEntityData().then(() => {});
                            this.onSaveEdits();
                        }
                    } else {
                        this.sendOrderDisabled = true;
                        this.cancelOrderDisabled = true;
                        //this.reloadEntityData().then(() => {});
                        this.onSaveEdits();
                    }
                }).catch((error) => {
                    // Don't do anything anymore
                });
        },
        changePaymentMethod() {
            this.isLoadingPaymentMethod = true;
            this.CpContractApi.changePaymentMethod(this.orderId, this.selectedNewPaymentMethod)
                .catch((error) => {
                    if ( error.response && error.response.data && error.response.data.error ) {
                       this.showTranslatedErrorMessagePopup(error.response.data.error);
                    }
                    this.isLoadingPaymentMethod = false;
                    throw new Error('Skipping then.');
                })
                .then((res) => {
                    this.isLoadingPaymentMethod = false;
                    if (res && res.data && res.data.sErrorMessage !== undefined) {
                        //this.cpShowNotification({ title: 'Error', message: res.data.sErrorMessage });
                        this.showTranslatedErrorMessagePopup(res.data.sErrorMessage);
                        if (res.data.sError === 401) {
                            this.sendOrderDisabled = true;
                            this.cancelOrderDisabled = true;
                            this.isPaymentMethodDisabled = true;
                            //this.reloadEntityData().then(() => {});
                            this.onSaveEdits();
                        }
                    } else {
                        this.sendOrderDisabled = true;
                        this.cancelOrderDisabled = true;
                        this.isPaymentMethodDisabled = true;
                        //this.reloadEntityData().then(() => {});
                        window.location.reload();
                    }
                }).catch((error) => {
                    // Don't do anything anymore
                });
        },
        filteredPaymentMethodCriteria() {
            const paymentMethodCriteria = new Criteria(1, 25);
            const aPaymentIDs = [];
            if ( this.order ) {
                for (let i = 0; i < this.order.transactions.length; i += 1) {
                    aPaymentIDs.push(this.order.transactions[i].paymentMethodId);
                }
                paymentMethodCriteria.addFilter(Criteria.equals('salesChannels.id', this.order.salesChannelId));
            }
            paymentMethodCriteria.setIds(aPaymentIDs);
            let oFilter = Criteria.equals('afterOrderEnabled', 1);
            if ( aPaymentIDs ) {
                oFilter = Criteria.multi('OR', [oFilter, Criteria.equalsAny('id', aPaymentIDs)]);
            }
            paymentMethodCriteria.addFilter(oFilter);
            return paymentMethodCriteria;
        },
        changedValue(entity,item){
            this.selectedNewPaymentMethod = item.id;
        },
        showTranslatedErrorMessagePopup(message) {
            if ( Shopware.Utils.format.translate(message) && (Shopware.Utils.format.translate(message) !== message) ) {
                console.log("Translator triggered.");
                this.createNotificationError({message: Shopware.Utils.format.translate(message)});
            } else {
                console.log("Translator failed: " + Shopware.Utils.format.translate(message) + " - " + message);
                this.createNotificationError({message: message});
            }
        }
    },

});

let hideStatusChanges = {
    template:sw_order_details_state_card_from,
    data(){
        return {
            cpHideElement: true
        }
    },
    computed: {
        paymentRepository() {
            return this.repositoryFactory.create('payment');
        },
        transaction() {
            for (let i = 0; i < this.order.transactions.length; i += 1) {
                if (!['cancelled', 'failed'].includes(this.order.transactions[i].stateMachineState.technicalName)) {
                    return this.order.transactions[i];
                }
            }
            return this.order.transactions.last();
        }
    },
    created(){
        let paymentMethod = this.transaction.paymentMethod;
        if(paymentMethod){
            if(paymentMethod?.handlerIdentifier === 'SicoCreditPlus\\Service\\CreditPlusPayment'){
                this.cpHideElement = true;
            } else {
                this.cpHideElement = false;
            }
        } else {
            const criteria = new Criteria(1, 1);
            criteria.addFilter(Criteria.equals('handlerIdentifier','SicoCreditPlus\\Service\\CreditPlusPayment'));
            this.paymentRepository.get(this.transaction.paymentMethodId,Shopware.Context.api).then(entity => {
                if(entity.handlerIdentifier === 'SicoCreditPlus\\Service\\CreditPlusPayment'){
                    this.cpHideElement = true;
                } else {
                    this.cpHideElement = false;
                }
            });
        }
    }
};
let hideStatusChanges2 = {...hideStatusChanges}
Component.override('sw-order-details-state-card',hideStatusChanges);
hideStatusChanges2.template = sw_order_general_info;
Component.override('sw-order-general-info',hideStatusChanges2);
