import deDE from './snippet/de-DE.json';
import enGB from './snippet/en-GB.json';

import './page/cp-creditplus';
import './page/cp-prodgroup-detail';
import './page/cp-offered-options';
import './page/cp-offered-options-detail';
import './view/cp-productgroup-detail-base';
import './view/cp-productgroup-detail-article';


Shopware.Module.register('sico-creditplus',{
    type:'plugin',
    name:'SicoCreditplus',
    title: 'Creditplus',
    description: 'Credit Plus Plugin',
    color:'#17ff96',
    icon:'regular-cog',

    snippets:{
        'de-DE':deDE,
        'en-GB':enGB
    },
    routes:{
        index: {
            component:'cp-creditplus',
            path:'index'
        },
        prodgroupNew: {
            component:'cp-prodgroup-detail',
            path:'prodgroup-new',
            redirect: {
                name: 'sico.creditplus.prodgroupNew.base'
            },
            children:{
                base:{
                    component: 'cp-productgroup-detail-base',
                    path: 'base',
                    meta: {
                        parentPath: 'sico.creditplus.index'
                    }
                },
                article:{
                    component: 'cp-productgroup-detail-article',
                    path: 'article',
                    meta: {
                        parentPath: 'sico.creditplus.index'
                    }
                }
            }
        },
        prodgroupDetail:{
            component:'cp-prodgroup-detail',
            path:'prodgroup-detail/:id?',

            props: {
                default: (route) => ({ prodgroupId: route.params.id })
            },

            redirect: {
                name: 'sico.creditplus.prodgroupDetail.base'
            },

            children:{
                base:{
                    component: 'cp-productgroup-detail-base',
                    path: 'base',
                    meta: {
                        parentPath: 'sico.creditplus.index'
                    }
                },
                article:{
                    component: 'cp-productgroup-detail-article',
                    path: 'article',
                    meta: {
                        parentPath: 'sico.creditplus.index'
                    }
                }
            }
        },
        offeredOptionsList:{
            component:'cp-offered-options',
            path:'offered-options'
        },
        offeredOptionsDetail:{
            component:'cp-offered-options-detail',
            path:'detail/:id?',
            props: {
                default: (route) => ({ offeredOptionId: route.params.id })
            },
            meta: {
                parentPath: 'sico.creditplus.offeredOptionsList'
            }
        }
    },
    navigation: [{
        id:'sico-creditplus',
        label:'CreditPlus',
        color:'#17ff99',
        icon:'regular-cog',
        parent: 'sw-order'
    },{
        id:'sico-productgroup',
        label:'CreditPlus Finanzierung',
        color:'#17ff99',
        path: 'sico.creditplus.index',
        parent:'sico-creditplus'
    },{
        id:'sico-offered-option',
        label:'Zinstabelle',
        color:'#17ff99',
        path: 'sico.creditplus.offeredOptionsList',
        parent:'sico-creditplus'
    }]
});
