import template from './cp-creditplus.html.twig';

const { Component, Mixin } = Shopware;
const { Criteria } = Shopware.Data;

Shopware.Component.register('cp-creditplus',{
    template:template,
    inject:['repositoryFactory'],
    data(){
        return {
            prodgroups:null
        }
    },
    created(){
        this.create();
    },
    computed:{
        productgroupColumns(){
            return this.getProductgroupColumns();
        },
        getProductgroupRepo(){
            return this.repositoryFactory.create('sico_productgroup');
        },
        getOfferedOptionRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
    },
    methods: {
        create(){
            let repo = this.getProductgroupRepo;
            let items = repo.search(this.getProdgroupCriteria(),Shopware.Context.api).then((response) => {
                this.prodgroups = response;
            });
        },
        getProdgroupCriteria(){
            const criteria = new Criteria(1, 100);
            criteria.addSorting(Criteria.sort('sicoName', 'ASC'));
            return criteria;
        },
        getProductgroupColumns(){
            return [{
                property:'sicoName',
                label: 'Name',//this.$tc('sw-product.list.columnName')
                inlineEdit:'string',
                allowResize: true,
                primary: true
            }];
        },
        onDeleteFailed(id, errorResponse){
            /*Wenn das Löschen fehlschlägt liegt es vielleicht daran, dass referenzen auf diesen Eintrag liegt
            daher versuchen wir mal die einträge zu löschen
             */
            this.getOfferedOptionRepository.search(
                this.offeredOptionsCriteria(id),Shopware.Context.api
            ).then((response) => {
                this.getOfferedOptionRepository.delete(response,Shopware.Context.api).then(() => {
                    this.getProductgroupRepo.delete(id,Shopware.Context.api).then(() => {});
                });
            })
        },
        offeredOptionsCriteria(prodgroupId){
            let criteria = new Criteria();
            criteria.addFilter(Criteria.equals('sicoProdgroupId', prodgroupId));
            return criteria;
        },
        test(){
            console.log('drin');
        }
    }
});
