import template from './cp-offered-options-detail.html.twig'

const { Component, Mixin } = Shopware;
const { Criteria } = Shopware.Data;

Shopware.Component.register('cp-offered-options-detail',{
    template:template,
    data(){
        return {
            offeredOption:null,
            isLoading:false,
            isSaveSuccessful: false
        }
    },
    inject:['repositoryFactory', 'cacheApiService'],
    props: {
        offeredOptionId: {
            type: String,
            required: false,
            default: null
        }
    },
    computed:{
        getOfferedOptionCriteria(){
            return new Criteria();
        },
        getOfferedOptionRepository(){
            return this.repositoryFactory.create('sico_offered_option');
        },
        tooltipSave() {
            //const systemKey = this.$device.getSystemKey();

            return {
                message: `Save Button`,
                appearance: 'light'
            };
        },
    },
    methods:{
        onComponentCreation() {
            this.isLoading = true;
            if(this.offeredOptionId === null) {
                this.offeredOption = this.getOfferedOptionRepository.create(Shopware.Context.api);
                this.isLoading = false;
            } else {
                this.getOfferedOptionRepository.get(this.offeredOptionId,Shopware.Context.api,this.getOfferedOptionCriteria).then((res) => {
                    this.offeredOption = res;
                    this.isLoading = false;
                });
            }
            //
        },
        onSave(){
            this.isLoading = true;
            console.log(this.offeredOption)
            this.getOfferedOptionRepository.save(this.offeredOption,Shopware.Context.api).then(() => {
                this.isLoading = false;
                this.isSaveSuccessful = true;
                window.setTimeout(()=>{this.isSaveSuccessful = false},2000);
                this.cacheApiService.clear().then();
            });
        },
        changedValue(entity,item){
            this.offeredOption.sicoProdgroupId = item.id;
        }
    },
    created(){
        this.onComponentCreation();
    },
});
