import template from './cp-productgroup-detail-article.html.twig';
import prodGroupState from "../../page/cp-prodgroup-detail/state";
const { Criteria,EntityCollection } = Shopware.Data;

const { mapPageErrors, mapState, mapGetters } = Shopware.Component.getComponentHelper();

Shopware.Component.register('cp-productgroup-detail-article',{
    template:template,
    inject: ['repositoryFactory'],
    data(){
        return {
            prodgroup: null,
        }
    },
    computed: {

        prodgroupRepository() {
            return this.repositoryFactory.create('sico_productgroup');
        },
        prodgroupCriteria(){
            let criteria = new Criteria();
            // criteria.addAssociation('product');
            criteria.addAssociation('prodgroupSalesChannel');
            criteria.addAssociation('dynamicProductGroup');
            return criteria;
        },
        ...mapState('cpProdGroupState', [
            'prodgroup'
        ]),
        productColumns(){
            return [{
                property: 'name',
                label: 'Name',
            }, {
                property: 'productNumber',
                naturalSorting: true,
                label: 'Produkt Nummer',
                align: 'right',
                allowResize: true
            }, {
                property: 'manufacturer.name',
                label: 'Hersteller Name',
                allowResize: true
            }, {
                property: 'active',
                label: 'Aktiv',
                inlineEdit: 'boolean',
                allowResize: true,
                align: 'center'
            }];
        }
    },
    created() {
        this.isLoading = true;
        let prodgroupId = this.$route.params.id;
        this.localProdgroupId = prodgroupId;

        if (prodgroupId !== null) {
            this.prodgroupRepository.get(prodgroupId, Shopware.Context.api, this.prodgroupCriteria).then((res) => {

                this.prodgroup = res;
            });
        }
    }
});
