<?php declare(strict_types=1);
/**
 * Created by PhpStorm.
 * User: Philipp.Holzmann
 * Date: 03.01.2020
 * Time: 15:25
 */

namespace SicoCreditPlus\Service;

use Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionCollection;
use Shopware\Core\Checkout\Payment\Cart\AsyncPaymentTransactionStruct;
use Shopware\Core\Checkout\Payment\Cart\PaymentHandler\AbstractPaymentHandler;
use Shopware\Core\Checkout\Payment\Cart\PaymentHandler\PaymentHandlerType;
use Shopware\Core\Checkout\Payment\Cart\PaymentTransactionStruct;
use Shopware\Core\Checkout\Payment\Cart\RefundPaymentTransactionStruct;
use Shopware\Core\Checkout\Payment\PaymentException;
use Shopware\Core\Framework\App\Payload\SourcedPayloadInterface;
use Shopware\Core\Framework\App\Payment\Payload\Struct\PaymentPayload;
use Shopware\Core\Framework\App\Payment\Response\PaymentResponse;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\Struct\Struct;
use Shopware\Core\Framework\Uuid\Uuid;
use Shopware\Core\Framework\Validation\DataBag\RequestDataBag;
use Shopware\Core\System\SalesChannel\Context\AbstractSalesChannelContextFactory;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use SicoCreditPlus\Components\SicoCreditPlusHelper;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;

class CreditPlusPayment extends AbstractPaymentHandler
{
    /**
     * @var SicoCreditPlusHelper
     */
    private $creditPlusHelper;

    private EntityRepository $orderTransactionRepository;
    protected ?AbstractSalesChannelContextFactory $oSalesChannelContextFactory = null;

    public function __construct(SicoCreditPlusHelper $creditPlusHelper,
                                AbstractSalesChannelContextFactory $oSalesChannelContextFactory,
                                EntityRepository $orderTransactionRepository
    )
    {
        $this->creditPlusHelper = $creditPlusHelper;
        $this->oSalesChannelContextFactory = $oSalesChannelContextFactory;
        $this->orderTransactionRepository = $orderTransactionRepository;

    }

    public function pay(
        Request $request,
        PaymentTransactionStruct $transaction,
        Context $context,
        ?Struct $validateStruct
    ): RedirectResponse
    {
        $sReturnURL = $transaction->getReturnUrl();
        return new RedirectResponse($sReturnURL);
    }
    public function supports(PaymentHandlerType $type, string $paymentMethodId, Context $context): bool
    {
        return false;
    }
    public function finalize(Request $request, PaymentTransactionStruct $transaction, Context $context): void
    {
        $orderTransactionId = $transaction->getOrderTransactionId();
        $salesChannelId = $context->getSource()->getSalesChannelId();
        $oSalesChannelContext = $this->oSalesChannelContextFactory->create(Uuid::randomHex(), $salesChannelId);

        $this->creditPlusHelper->setSalesChannelContext($oSalesChannelContext);
        $this->creditPlusHelper->setContext($context);

        $sTargetUrl = $this->creditPlusHelper->getTargetURLForFinishingPayment($transaction->getOrderTransactionId(),$salesChannelId);

        $criteria = new Criteria();
        $criteria->addAssociation('order');
        $criteria->addFilter(new EqualsFilter('id', $orderTransactionId));
        $oTransactionEntity = $this->orderTransactionRepository->search($criteria, $context)->first();

        $oOrder = $oTransactionEntity->getOrder();

        $oOrderTransactionCollection = new OrderTransactionCollection();
        $oOrderTransactionCollection->add($oTransactionEntity);
        $oOrder->setTransactions($oOrderTransactionCollection);
        $this->creditPlusHelper->sendAdditionalMessageMail($oSalesChannelContext,$oOrder,$sTargetUrl);
    }
}
