<?php
/**
 * Created by PhpStorm.
 * @author mihovil.bubnjar
 * @date 18.08.2023
 * @time 08:52
 */

namespace SicoCreditPlus\Service\Interfaces;

use Exception;
use SicoCreditPlus\Core\Content\SicoCreditPlusSavedCart\SicoCreditPlusSavedCartEntity;

interface SavedCartSerializerInterface
{
	/**
	 * @param SicoCreditPlusSavedCartEntity $oSavedCart
	 * @return string
	 * @throws Exception If serialization failed
	 */
	public function serialize(SicoCreditPlusSavedCartEntity $oSavedCart): string;

	/**
	 * @param string $sSerializedSavedCart
	 * @return SicoCreditPlusSavedCartEntity
	 * @throws Exception If unserialization failed
	 */
	public function unserialize(string $sSerializedSavedCart): SicoCreditPlusSavedCartEntity;
}
