<?php

namespace SicoCreditPlus\Subscriber;

use Shopware\Core\Checkout\Cart\Event\CheckoutOrderPlacedEvent;
use Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\System\SalesChannel\SalesChannelEntity;
use Shopware\Core\System\StateMachine\StateMachineRegistry;
use Shopware\Core\System\StateMachine\Transition;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use SicoCreditPlus\Core\Content\CreditPlusPayment\CreditPlusPaymentEntity;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Session\Session;

class CheckoutOrderPlacedSubscriber implements EventSubscriberInterface{

	/** @var EntityRepository */
	private $oOrderRepo;

	/**
	 * @var SystemConfigService
	 */
	protected $oSystemConfigService;

	/** @var EntityRepository */
	protected $oCpPaymentRepo;

	/**
	 * @var StateMachineRegistry
	 */
	private $oStateMachineRegistry;


	public function __construct(
        EntityRepository $oOrderRepo,
								SystemConfigService $oSystemConfigService,
        EntityRepository $oCpPaymentRepo,
								StateMachineRegistry $oStateMachineRegistry)
	{
		$this->oOrderRepo = $oOrderRepo;
		$this->oSystemConfigService = $oSystemConfigService;
		$this->oCpPaymentRepo = $oCpPaymentRepo;
		$this->oStateMachineRegistry = $oStateMachineRegistry;
	}

	/**
	 * @return string[] Array of 'Event Class' => 'subscriber function'
	 */
	public static function getSubscribedEvents()
	{
		return [CheckoutOrderPlacedEvent::class => 'onOrderPlaced'];
	}

	public function onOrderPlaced(CheckoutOrderPlacedEvent $event){
		$orderId = $event->getOrder()->getId();
		//$cpDealerOrderNumber = $this->oSession->get('cpDealerOrderNumber');
        //@ToDo: dealer order number aus session holen
        $cpDealerOrderNumber = null;
		if($cpDealerOrderNumber != null){
			$customFields = $event->getOrder()->getCustomFields();
			$customFields['cpDealerOrderNumber'] = $cpDealerOrderNumber;
			$this->oOrderRepo->update([[
				'id' => $orderId,
				'customFields' => $customFields
			]],$event->getContext());

			$oCpPaymentColl = $this->oCpPaymentRepo->search((new Criteria())->addFilter(new EqualsFilter('orderNumber',$cpDealerOrderNumber)),$event->getContext());
			/** @var CreditPlusPaymentEntity $oCpPaymentEntity */
			$oCpPaymentEntity = $oCpPaymentColl->first();
			$this->oCpPaymentRepo->update([[
				'id' => $oCpPaymentEntity->getId(),
				'orderId'=> $event->getOrder()->getId(),
				'versionId' => $event->getOrder()->getVersionId()
			]],$event->getContext());

            /*
			if($this->oSystemConfigService->get('SicoCreditPlus.config.sTransactionMode',$event->getSalesChannelId()) == 'inorder'){
				$this->oStateMachineRegistry->transition(new Transition(
					OrderTransactionDefinition::ENTITY_NAME,
					$orderId,
					'borrowing_request_shown',
					'stateId'
				),$event->getContext());
			}
            */

		}
	}
	/**
	 * Prüft, ob die aktuelle Einstellung "inorder" ist und speichert dies zwischen.
	 * @return bool
	 */
	private function isInorderMode(string $sSalesChannelId) {
		$bIsInorderMode = ($this->oSystemConfigService->get('SicoCreditPlus.config.sTransactionMode',$sSalesChannelId) == 'inorder');
		return $bIsInorderMode;
	}
}
