<?php
/**
 * Created by PhpStorm.
 * User: philipp.holzmann
 * Date: 04.02.2021
 * Time: 08:51
 */

namespace SicoCreditPlus\Subscriber;
use Doctrine\DBAL\Connection;
use SicoCreditPlus\Components\SicoCreditPlusLogger;
use \Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Shopware\Core\System\SystemConfig\SystemConfigService;

class ResponseSubscriber implements EventSubscriberInterface{

	/** @var SystemConfigService */
	protected $_oSystemConfigService;

    /** @var Connection */
    protected $oConnection;

    /** @var SicoCreditPlusLogger */
    protected $oLogger;

	public function __construct(SystemConfigService $systemConfigService,Connection $connection,SicoCreditPlusLogger $oLogger){
		$this->_oSystemConfigService = $systemConfigService;
        $this->oConnection = $connection;
        $this->oLogger = $oLogger;
	}

	/**
	 * @return array[] Array of 'Event class' => ['subscriber function', priority]
	 */
	public static function getSubscribedEvents()
	{
		return [
			KernelEvents::RESPONSE => ['handleSecurityHeaders',-266]
			//KernelEvents::RESPONSE => 'handleSecurityHeaders'
		];
	}

	public function handleSecurityHeaders(ResponseEvent $event): void{
		$requestUri = $event->getRequest()->getRequestUri();
		if(preg_match('/\/payment\/creditplus\/[0-9a-zA-Z-]*\/popup/',$requestUri) == 1 ||
			preg_match('/\/payment\/creditplus\/[0-9a-zA-Z-]*\/iframe/',$requestUri) == 1 ||
			$requestUri == '/payment/creditplus' ||
			preg_match('/^\/payment\/creditplus\/dispatch\/data\//',$requestUri) == 1 ||
			preg_match('/^\/payment\/creditplus\/beforeOrder/',$requestUri) == 1 ||
			preg_match('/^\/payment\/creditplus\/afterCreditForm/',$requestUri) == 1
		){
            $aSalesChannelIds = $this->oConnection->fetchAllAssociative('SELECT LOWER(HEX(id)) AS id FROM sales_channel');
            $url = '';
            $bFirst = true;
            foreach($aSalesChannelIds as $aSalesChannelId){
                $wsdl = $this->_oSystemConfigService->get('SicoCreditPlus.config.sWSDL',$aSalesChannelId['id']);
                $bIsMatched = preg_match('/((http|https)\:\/\/)(([a-z\-0-9]*\.)*[a-z]{2})/',$wsdl,$urlParts);
                if($bIsMatched === 1){
                    if(strpos($url,$urlParts[0]) === false){
                        if(!empty($urlParts[0])){
                            if($bFirst){
                                $bFirst = false;
                            } else {
                                $url .= ' ';
                            }
                            $url .= $urlParts[0];
                        }
                    }
                } else {
                    $this->oLogger->log(false,'WSDL url is not a url',['wsdl' => $wsdl,'bIsMatched' => $bIsMatched],$aSalesChannelId['id']);
                }
            }

			$event->getResponse()->headers->set('X-Frame-Options', '');
			$event->getResponse()->headers->set('Content-Security-Policy','frame-ancestors \'self\' '.$url);

		}
	}

}
