<?xml version="1.0" encoding="utf-8"?>
<!-- JM  v0.5  4 November 2010
     Stylesheet to style Print schemas

     Copyright (c) 2005-2010 Elsevier B.V.
     $Id: print.xsl,v 1.3 2010-11-04 14:51:10 jmigchie Exp $
-->

<xsl:stylesheet xmlns:p="http://www.elsevier.com/xml/schema/transport/print-1.1/print"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output encoding="utf-8" method="html"/>

    <xsl:strip-space elements="*"/>

    <xsl:key name="id-key" match="p:id" use="."/>

    <xsl:template match="/">
        <html>
            <head>
                <title>
                    <xsl:text>print.xml</xsl:text>
                </title>
                <style type="text/css">
      <xsl:comment>
        <xsl:text>
        * { font-family: Verdana, Arial, sans-serif;
            font-size: 10pt;
            color: black; }
        table { vertical-align: top; }
        tr { vertical-align: top; }
        th { text-align: left;
             padding-left: 10px;
             padding-right: 10px; }
        td { padding-left: 10px;
             padding-right: 10px; }
        body { background-color: wheat;
               margin: 2em; }
        .warning { background-color: red; }
        .error { color: red; }
        .fpo { background-color: red; }
        </xsl:text>
      </xsl:comment>
      </style>
            </head>
            <body>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="p:print">
        <xsl:apply-templates/>
    </xsl:template>


    <!-- serial-issue-properties -->

    <xsl:template match="p:serial-issue-properties">
        <table>
            <!-- two columns -->
            <xsl:apply-templates/>
        </table>
    </xsl:template>

    <xsl:template match="p:jid">
        <tr>
            <td>
                <b>
                    <xsl:text>JID</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:issn">
        <tr>
            <td>
                <b>
                    <xsl:text>ISSN</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:volume-issue-number">
        <tr>
            <td>
                <b>
                    <xsl:text>Volume/Issue</xsl:text>
                </b>
            </td>
            <td>
                <xsl:apply-templates/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:vol-first">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:vol-last">
        <xsl:text>&#x02013;</xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:iss-first">
        <xsl:text>&#x000A0;/&#x000A0;</xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:iss-last">
        <xsl:text>&#x02013;</xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:suppl">
        <xsl:text>&#x000A0;</xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:cover-date-printed">
        <tr>
            <td>
                <b>
                    <xsl:text>Cover date as printed</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <!-- / serial-issue-properties -->

    <!-- page-totals -->

    <xsl:template match="p:page-totals">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="p:no-pages-prelims">
        <tr>
            <td>
                <b>
                    <xsl:text>Total number of prelim pages</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:no-pages-interior">
        <tr>
            <td>
                <b>
                    <xsl:text>Total number of interior pages</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:no-pages-extra">
        <tr>
            <td>
                <b>
                    <xsl:text>Total number of additional pages</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:no-pages-bm">
        <tr>
            <td>
                <b>
                    <xsl:text>Total number of backmatter pages</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:no-pages-total">
        <tr>
            <td>
                <b>
                    <xsl:text>Total number of pages</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <!-- / page-totals -->

    <!-- book-project-properties -->

    <xsl:template match="p:book-project-properties">
        <table>
            <xsl:apply-templates/>
        </table>
    </xsl:template>

    <xsl:template match="p:isbn">
        <tr>
            <td>
                <b>
                    <xsl:text>ISBN</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:title">
        <tr>
            <td>
                <b>
                    <xsl:text>Title</xsl:text>
                </b>
            </td>
            <td>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <!-- / book-project-properties -->

    <xsl:template match="p:print-content">
        <br/>
        <xsl:apply-templates/>
        <p>
            <font class="error">* Marked items may be part of a split item!</font>
        </p>
    </xsl:template>

    <xsl:template match="p:fascicle">
        <br/>
        <table cols="7">
            <!-- seven columns -->
            <xsl:apply-templates/>
        </table>
    </xsl:template>

    <xsl:template match="p:description">
        <tr>
            <td colspan="7">
                <b>
                    <xsl:text>Description:</xsl:text>
                </b>
                <xsl:text> </xsl:text>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:fascicle-isbn">
        <tr>
            <td colspan="7">
                <b>
                    <xsl:text>Fascicle ISBN:</xsl:text>
                </b>
                <xsl:text> </xsl:text>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="p:spine-width">
        <tr>
            <td colspan="7">
                <b>
                    <xsl:text>Spine width:</xsl:text>
                </b>
                <xsl:text> </xsl:text>
                <xsl:value-of select="."/>
                <xsl:text>&#x000A0;</xsl:text>
                <xsl:value-of select="@unit"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="p:print-pdf">
        <xsl:if test="not(preceding-sibling::p:print-pdf)">
            <xsl:call-template name="print-pdf-heading"/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="@type = 'fpo'">
                <tr class="fpo">
                    <xsl:call-template name="print-pdf-content"/>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:call-template name="print-pdf-content"/>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="print-pdf-heading">
        <tr>
            <th>
                <xsl:text>Sequence no.</xsl:text>
            </th>
            <th>
                <xsl:text>Pathname</xsl:text>
            </th>
            <th>
                <xsl:text>Nr of physical pages</xsl:text>
            </th>
            <th>
                <xsl:text>Pagination</xsl:text>
            </th>
            <th>
                <xsl:text>Colour pages</xsl:text>
            </th>
            <th>
                <xsl:text>ID</xsl:text>
            </th>
            <th>
                <xsl:text>Remarks</xsl:text>
            </th>
        </tr>
    </xsl:template>

    <xsl:template name="print-pdf-content">
        <xsl:apply-templates select="p:sequence-no"/>
        <xsl:apply-templates select="p:pathname"/>
        <xsl:apply-templates select="p:nr-physical-pages"/>
        <xsl:apply-templates select="p:pagination"/>
        <xsl:choose>
            <xsl:when test="p:colour-pages">
                <xsl:apply-templates select="p:colour-pages"/>
            </xsl:when>
            <xsl:otherwise>
                <td>-</td>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="p:id">
                <xsl:apply-templates select="p:id"/>
            </xsl:when>
            <xsl:otherwise>
                <td>-</td>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="p:remarks">
                <xsl:apply-templates select="p:remarks"/>
            </xsl:when>
            <xsl:otherwise>
                <td>-</td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="p:sequence-no">
        <td>
            <b>
                <xsl:value-of select="."/>
                <xsl:text>&#x000A0;(</xsl:text>
                <xsl:value-of select="../@type"/>
                <xsl:text>)</xsl:text>
            </b>
        </td>
    </xsl:template>

    <xsl:template match="p:pathname">
        <td>
            <xsl:value-of select="."/>
        </td>
    </xsl:template>

    <xsl:template match="p:nr-physical-pages">
        <td>
            <xsl:value-of select="."/>
        </td>
    </xsl:template>

    <xsl:template match="p:pagination">
        <td>
            <xsl:apply-templates/>
        </td>
    </xsl:template>

    <xsl:template match="p:first-page">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:last-page">
        <xsl:text>&#x02013;</xsl:text>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:colour-pages">
        <td>
            <xsl:apply-templates/>
        </td>
    </xsl:template>

    <xsl:template match="p:colour-page">
        <xsl:if test="not(position() = 1)">
            <xsl:text>,&#x000A0;</xsl:text>
        </xsl:if>
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="p:id">
        <xsl:variable name="fascicle-id">
            <xsl:value-of select="generate-id(../..)"/>
        </xsl:variable>
        <td>
            <xsl:choose>
                <xsl:when test="count(key('id-key',.)[generate-id(../..) = $fascicle-id]) > 1">
                    <font class="error"><xsl:value-of select="."/> *</font>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>

    <xsl:template match="p:remarks">
        <td>
            <xsl:value-of select="."/>
        </td>
    </xsl:template>

</xsl:stylesheet>
